/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.plot;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.geo.layout.MapLayout;
import org.meteoinfo.geo.legend.MapFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapLayoutPlot
extends JFrame {
    private MapLayout mapLayout1;

    public MapLayoutPlot() {
        this.initComponents();
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        this.mapLayout1 = new MapLayout();
        this.setDefaultCloseOperation(3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mapLayout1, GroupLayout.Alignment.TRAILING, -1, 658, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mapLayout1, GroupLayout.Alignment.TRAILING, -1, 479, Short.MAX_VALUE));
        this.pack();
    }

    public MapLayout getMapLayout() {
        return this.mapLayout1;
    }

    public void loadProjectFile(String aFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(aFile);
        Element root = doc.getDocumentElement();
        Properties property = System.getProperties();
        String path = System.getProperty("user.dir");
        property.setProperty("user.dir", new File(aFile).getAbsolutePath());
        String pPath = new File(aFile).getParent();
        ArrayList<MapFrame> mfs = new ArrayList<MapFrame>();
        Element mapFrames = (Element)root.getElementsByTagName("MapFrames").item(0);
        if (mapFrames == null) {
            MapFrame mf = new MapFrame();
            mf.importProjectXML(pPath, root);
            mf.setActive(true);
            mfs.add(mf);
        } else {
            NodeList mfNodes = mapFrames.getElementsByTagName("MapFrame");
            for (int i = 0; i < mfNodes.getLength(); ++i) {
                Node mapFrame = mfNodes.item(i);
                MapFrame mf = new MapFrame();
                mf.importProjectXML(pPath, (Element)mapFrame);
                mfs.add(mf);
            }
        }
        this.mapLayout1.setMapFrames(mfs);
        this.mapLayout1.importProjectXML(root);
        property.setProperty("user.dir", path);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MapLayoutPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MapLayoutPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MapLayoutPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MapLayoutPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MapLayoutPlot().setVisible(true);
            }
        });
    }
}

