/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Opaque;
import us.hebi.matlab.mat.types.Sparse;
import us.hebi.matlab.mat.util.Preconditions;

class Mat5ArrayFlags {
    private static final int FLAG_MASK_TYPE_ID = 255;
    private static final int FLAG_BIT_LOGICAL = 512;
    private static final int FLAG_BIT_GLOBAL = 1024;
    private static final int FLAG_BIT_COMPLEX = 2048;

    Mat5ArrayFlags() {
    }

    static int[] forArray(boolean global, Array array) {
        if (array instanceof Mat5Serializable.Mat5Attributes) {
            Mat5Serializable.Mat5Attributes attr = (Mat5Serializable.Mat5Attributes)((Object)array);
            return Mat5ArrayFlags.create(array.getType(), global, attr.isLogical(), attr.isComplex(), attr.getNzMax());
        }
        Preconditions.checkArgument(!(array instanceof Sparse), "Sparse matrices must implement Mat5Attributes");
        boolean logical = array instanceof Matrix && ((Matrix)array).isLogical();
        boolean complex = array instanceof Matrix && ((Matrix)array).isComplex();
        return Mat5ArrayFlags.create(array.getType(), global, logical, complex, 0);
    }

    static int[] forOpaque(boolean global, Opaque opaque) {
        return Mat5ArrayFlags.create(MatlabType.Opaque, false, false, false, 0);
    }

    private static int[] create(MatlabType type, boolean global, boolean logical, boolean complex, int nzMax) {
        int attributes = type.id() & 0xFF;
        if (logical) {
            attributes |= 0x200;
        }
        if (global) {
            attributes |= 0x400;
        }
        if (complex) {
            attributes |= 0x800;
        }
        return new int[]{attributes, nzMax};
    }

    static MatlabType getType(int[] arrayFlags) {
        return MatlabType.fromId(arrayFlags[0] & 0xFF);
    }

    static boolean isComplex(int[] arrayFlags) {
        return (arrayFlags[0] & 0x800) != 0;
    }

    static boolean isGlobal(int[] arrayFlags) {
        return (arrayFlags[0] & 0x400) != 0;
    }

    static boolean isLogical(int[] arrayFlags) {
        return (arrayFlags[0] & 0x200) != 0;
    }

    static int getNzMax(int[] arrayFlags) {
        return arrayFlags[1];
    }
}

