/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.format.NumberStore;
import us.hebi.matlab.mat.format.UniversalNumberStore;
import us.hebi.matlab.mat.types.AbstractMatrixBase;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Preconditions;

class MatMatrix
extends AbstractMatrixBase
implements Mat5Serializable {
    private boolean logical;
    private final NumberStore real;
    private final NumberStore imaginary;
    private final boolean complex;
    private final MatlabType type;

    MatMatrix(int[] dims, MatlabType type, boolean logical, NumberStore real, NumberStore imaginary) {
        super(dims);
        this.type = Preconditions.checkNotNull(type);
        this.logical = logical;
        this.real = Preconditions.checkNotNull(real);
        if (real.getNumElements() != this.getNumElements()) {
            throw new IllegalArgumentException("Incorrect number of elements in real store");
        }
        this.imaginary = imaginary;
        boolean bl = this.complex = imaginary != null;
        if (this.complex && imaginary.getNumElements() != this.getNumElements()) {
            throw new IllegalArgumentException("Incorrect number of elements in imaginary store");
        }
    }

    @Override
    public MatlabType getType() {
        return this.type;
    }

    @Override
    public boolean isLogical() {
        return this.logical;
    }

    protected void setLogical(boolean value) {
        this.logical = value;
    }

    @Override
    public boolean isComplex() {
        return this.complex;
    }

    @Override
    public long getLong(int index) {
        return this.orLogical(this.real.getLong(index));
    }

    @Override
    public void setLong(int index, long value) {
        this.real.setLong(index, value);
    }

    @Override
    public double getDouble(int index) {
        return this.orLogical(this.real.getDouble(index));
    }

    @Override
    public void setDouble(int index, double value) {
        this.real.setDouble(index, value);
    }

    @Override
    public long getImaginaryLong(int index) {
        return this.orLogical(this.complex ? this.imaginary.getLong(index) : 0L);
    }

    @Override
    public void setImaginaryLong(int index, long value) {
        Preconditions.checkState(this.complex, "Matrix is not complex");
        this.imaginary.setLong(index, value);
    }

    @Override
    public double getImaginaryDouble(int index) {
        return this.orLogical(this.complex ? this.imaginary.getDouble(index) : 0.0);
    }

    @Override
    public void setImaginaryDouble(int index, double value) {
        Preconditions.checkState(this.complex, "Matrix is not complex");
        this.imaginary.setDouble(index, value);
    }

    @Override
    public int getMat5Size(String name) {
        return 8 + Mat5WriteUtil.computeArrayHeaderSize(name, this) + this.real.getMat5Size() + (this.complex ? this.imaginary.getMat5Size() : 0);
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        this.real.writeMat5(sink);
        if (this.complex) {
            this.imaginary.writeMat5(sink);
        }
    }

    NumberStore getRealStore() {
        return this.real;
    }

    @Override
    public void close() throws IOException {
        if (this == Mat5.EMPTY_MATRIX) {
            return;
        }
        this.real.close();
        if (this.imaginary != null) {
            this.imaginary.close();
        }
    }

    @Override
    protected int subHashCode() {
        return Compat.hash(new Object[]{this.logical, this.complex, this.type, UniversalNumberStore.hashCodeForType(this.real, this.logical, this.type), UniversalNumberStore.hashCodeForType(this.imaginary, this.logical, this.type)});
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        MatMatrix other = (MatMatrix)otherGuaranteedSameClass;
        return other.logical == this.logical && other.complex == this.complex && other.type == this.type && UniversalNumberStore.equalForType(other.real, this.real, this.logical, this.type) && UniversalNumberStore.equalForType(other.imaginary, this.imaginary, this.logical, this.type);
    }
}

