/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Bytes {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        int highestBit = Integer.highestOneBit(value);
        if (highestBit == value) {
            return value;
        }
        return highestBit << 1;
    }

    public static ByteOrder reverseByteOrder(ByteOrder order) {
        return order == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public static void reverseByteOrder(ByteBuffer buffer, int bytesPerElement) {
        int offset = buffer.position();
        int limit = buffer.limit();
        switch (bytesPerElement) {
            case 1: {
                break;
            }
            case 2: {
                for (int i = offset; i < limit; i += 2) {
                    buffer.putShort(i, Short.reverseBytes(buffer.getShort(i)));
                }
                break;
            }
            case 4: {
                for (int i = offset; i < limit; i += 4) {
                    buffer.putInt(i, Integer.reverseBytes(buffer.getInt(i)));
                }
                break;
            }
            case 8: {
                for (int i = offset; i < limit; i += 8) {
                    buffer.putLong(i, Long.reverseBytes(buffer.getLong(i)));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected number of bytes per element: " + bytesPerElement);
            }
        }
        buffer.order(Bytes.reverseByteOrder(buffer.order()));
    }

    public static int findFirst(byte[] bytes, int offset, int length, byte value, int defaultValue) {
        for (int i = 0; i < length; ++i) {
            if (bytes[offset + i] != value) continue;
            return i;
        }
        return defaultValue;
    }
}

