/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.nio.ByteOrder;
import us.hebi.matlab.mat.util.ByteConverter;

class HeapByteConverter
implements ByteConverter {
    HeapByteConverter() {
    }

    @Override
    public short getShort(ByteOrder order, byte[] bytes, int offset) {
        int value = order == ByteOrder.LITTLE_ENDIAN ? bytes[offset + 0] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 : (bytes[offset + 0] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
        return (short)value;
    }

    @Override
    public int getInt(ByteOrder order, byte[] bytes, int offset) {
        int value = order == ByteOrder.LITTLE_ENDIAN ? bytes[offset + 0] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24 : (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        return value;
    }

    @Override
    public long getLong(ByteOrder order, byte[] bytes, int offset) {
        long value = order == ByteOrder.LITTLE_ENDIAN ? (long)bytes[offset + 0] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56 : ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
        return value;
    }

    @Override
    public float getFloat(ByteOrder order, byte[] bytes, int offset) {
        return Float.intBitsToFloat(this.getInt(order, bytes, offset));
    }

    @Override
    public double getDouble(ByteOrder order, byte[] bytes, int offset) {
        return Double.longBitsToDouble(this.getLong(order, bytes, offset));
    }

    @Override
    public void putShort(short value, ByteOrder order, byte[] bytes, int offset) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            bytes[offset + 0] = (byte)(0xFF & value);
            bytes[offset + 1] = (byte)(0xFF & value >>> 8);
        } else {
            bytes[offset + 0] = (byte)(0xFF & value >>> 8);
            bytes[offset + 1] = (byte)(0xFF & value);
        }
    }

    @Override
    public void putInt(int value, ByteOrder order, byte[] bytes, int offset) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            bytes[offset + 0] = (byte)(0xFF & value);
            bytes[offset + 1] = (byte)(0xFF & value >>> 8);
            bytes[offset + 2] = (byte)(0xFF & value >>> 16);
            bytes[offset + 3] = (byte)(0xFF & value >>> 24);
        } else {
            bytes[offset + 0] = (byte)(0xFF & value >>> 24);
            bytes[offset + 1] = (byte)(0xFF & value >>> 16);
            bytes[offset + 2] = (byte)(0xFF & value >>> 8);
            bytes[offset + 3] = (byte)(0xFF & value);
        }
    }

    @Override
    public void putLong(long value, ByteOrder order, byte[] bytes, int offset) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            bytes[offset + 0] = (byte)(0xFFL & value);
            bytes[offset + 1] = (byte)(0xFFL & value >>> 8);
            bytes[offset + 2] = (byte)(0xFFL & value >>> 16);
            bytes[offset + 3] = (byte)(0xFFL & value >>> 24);
            bytes[offset + 4] = (byte)(0xFFL & value >>> 32);
            bytes[offset + 5] = (byte)(0xFFL & value >>> 40);
            bytes[offset + 6] = (byte)(0xFFL & value >>> 48);
            bytes[offset + 7] = (byte)(0xFFL & value >>> 56);
        } else {
            bytes[offset + 0] = (byte)(0xFFL & value >>> 56);
            bytes[offset + 1] = (byte)(0xFFL & value >>> 48);
            bytes[offset + 2] = (byte)(0xFFL & value >>> 40);
            bytes[offset + 3] = (byte)(0xFFL & value >>> 32);
            bytes[offset + 4] = (byte)(0xFFL & value >>> 24);
            bytes[offset + 5] = (byte)(0xFFL & value >>> 16);
            bytes[offset + 6] = (byte)(0xFFL & value >>> 8);
            bytes[offset + 7] = (byte)(0xFFL & value);
        }
    }

    @Override
    public void putFloat(float value, ByteOrder order, byte[] bytes, int offset) {
        this.putInt(Float.floatToRawIntBits(value), order, bytes, offset);
    }

    @Override
    public void putDouble(double value, ByteOrder order, byte[] bytes, int offset) {
        this.putLong(Double.doubleToRawLongBits(value), order, bytes, offset);
    }
}

