/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.util.Locale;

public final class PlatformInfo {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final boolean IS_WINDOWS = OS.contains("win");
    private static final boolean IS_MAC = OS.contains("mac");
    private static final boolean IS_UNIX = OS.contains("nix") || OS.contains("nux") || OS.indexOf("aix") > 0;
    private static final boolean IS_SOLARIS = OS.contains("sunos");
    private static final boolean IS_ANDROID = "0.9".equals(System.getProperty("java.specification.version"));
    private static final boolean IS_MATLAB = PlatformInfo.isMatlab0();
    private static final int JAVA_VERSION = PlatformInfo.getMajorJavaVersion0();

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isUnix() {
        return IS_UNIX;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static boolean isMatlab() {
        return IS_MATLAB;
    }

    public static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    public static int getJavaVersion() {
        return JAVA_VERSION;
    }

    private static boolean isMatlab0() {
        try {
            Class.forName("com.mathworks.jmi.Matlab", true, PlatformInfo.class.getClassLoader());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static int getMajorJavaVersion0() {
        if (PlatformInfo.isAndroid()) {
            return 6;
        }
        String version = System.getProperty("java.specification.version", "6");
        String majorVersion = version.startsWith("1.") ? version.substring(2) : version;
        return Integer.parseInt(majorVersion);
    }

    private PlatformInfo() {
    }
}

