/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.Field;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteothink.trajstat.forms.FrmMultiSel;

public class FrmAddData
extends JDialog {
    private final IApplication app;
    private File infile;
    private double undef = -9999.0;
    private JButton jButton_AddData;
    private JButton jButton_Cancel;
    private JButton jButton_InputFile;
    private JComboBox jComboBox_DataField;
    private JComboBox jComboBox_DateFormat;
    private JComboBox jComboBox_EndDateField;
    private JComboBox jComboBox_StartDateField;
    private JComboBox jComboBox_TimeZone;
    private JComboBox jComboBox_Type;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel_EndDate;
    private JLabel jLabel_StartDate;
    private JPanel jPanel_FieldProp;
    private JPanel jPanel_SelFields;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner_Precision;
    private JSpinner jSpinner_Width;
    private JTextArea jTextArea1;
    private JTextField jTextField_InputFile;
    private JTextField jTextField_MissingValue;
    private JTextField jTextField_Name;

    public FrmAddData(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        this.jTextArea1.setText("This tool will add data from a comma-delimited text file to trajectories according to the date field. The file must contain column titles as the first row and one or two date columns.");
        this.jPanel_SelFields.setEnabled(false);
        this.jPanel_FieldProp.setEnabled(false);
        this.jComboBox_DataField.removeAllItems();
        this.jComboBox_StartDateField.removeAllItems();
        this.jComboBox_EndDateField.removeAllItems();
        this.jComboBox_DateFormat.setEditable(true);
        this.jComboBox_DateFormat.removeAllItems();
        this.jComboBox_DateFormat.addItem("yyyyMMddHH");
        this.jComboBox_DateFormat.addItem("yyyy-MM-dd HH:mm");
        this.jComboBox_DateFormat.addItem("yyyy/M/d H:mm");
        this.jComboBox_TimeZone.removeAllItems();
        for (int i = -12; i <= 12; ++i) {
            this.jComboBox_TimeZone.addItem(this.getTimeZoneString(i));
        }
        this.jComboBox_TimeZone.setSelectedItem(this.getTimeZoneString(0));
        this.jButton_AddData.setEnabled(false);
        this.jComboBox_Type.removeAllItems();
        this.jComboBox_Type.addItem(DataType.INT);
        this.jComboBox_Type.addItem(DataType.DOUBLE);
        this.jComboBox_Type.addItem(DataType.STRING);
        this.jComboBox_Type.setSelectedIndex(1);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton_InputFile = new JButton();
        this.jTextField_InputFile = new JTextField();
        this.jPanel_SelFields = new JPanel();
        this.jLabel_StartDate = new JLabel();
        this.jComboBox_StartDateField = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_DataField = new JComboBox();
        this.jLabel_EndDate = new JLabel();
        this.jComboBox_EndDateField = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jComboBox_DateFormat = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jComboBox_TimeZone = new JComboBox();
        this.jButton_AddData = new JButton();
        this.jButton_Cancel = new JButton();
        this.jPanel_FieldProp = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextField_Name = new JTextField();
        this.jLabel4 = new JLabel();
        this.jComboBox_Type = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSpinner_Width = new JSpinner();
        this.jSpinner_Precision = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jTextField_MissingValue = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add data to trajectories");
        this.jScrollPane1.setBackground(new Color(255, 255, 204));
        this.jScrollPane1.setWheelScrollingEnabled(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setText("...");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton_InputFile.setText("Input File");
        this.jButton_InputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddData.this.jButton_InputFileActionPerformed(evt);
            }
        });
        this.jPanel_SelFields.setBorder(BorderFactory.createTitledBorder("Select Fields From Input File"));
        this.jLabel_StartDate.setText("Start Date:");
        this.jComboBox_StartDateField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Data Field:");
        this.jComboBox_DataField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DataField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddData.this.jComboBox_DataFieldActionPerformed(evt);
            }
        });
        this.jLabel_EndDate.setText("End Date:");
        this.jComboBox_EndDateField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Date Format:");
        this.jComboBox_DateFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel7.setText("Time Zone:");
        this.jComboBox_TimeZone.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel_SelFieldsLayout = new GroupLayout(this.jPanel_SelFields);
        this.jPanel_SelFields.setLayout(jPanel_SelFieldsLayout);
        jPanel_SelFieldsLayout.setHorizontalGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel_StartDate)).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING)).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel_EndDate))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_EndDateField, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_DataField, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_TimeZone, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_StartDateField, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_DateFormat, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel_SelFieldsLayout.setVerticalGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_StartDate).addComponent(this.jComboBox_StartDateField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_EndDate).addComponent(this.jComboBox_EndDateField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_DateFormat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jComboBox_TimeZone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox_DataField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_AddData.setText("Add Data");
        this.jButton_AddData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddData.this.jButton_AddDataActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddData.this.jButton_CancelActionPerformed(evt);
            }
        });
        this.jPanel_FieldProp.setBorder(BorderFactory.createTitledBorder("Data Field Property"));
        this.jLabel3.setText("Name:");
        this.jLabel4.setText("Type:");
        this.jComboBox_Type.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddData.this.jComboBox_TypeActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Width:");
        this.jLabel6.setText("Precision:");
        this.jLabel8.setText("Missing Value:");
        this.jTextField_MissingValue.setText("-9999.0");
        GroupLayout jPanel_FieldPropLayout = new GroupLayout(this.jPanel_FieldProp);
        this.jPanel_FieldProp.setLayout(jPanel_FieldPropLayout);
        jPanel_FieldPropLayout.setHorizontalGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_FieldPropLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField_MissingValue).addComponent(this.jSpinner_Width, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBox_Type, GroupLayout.Alignment.TRAILING, 0, 215, Short.MAX_VALUE).addComponent(this.jTextField_Name, GroupLayout.Alignment.TRAILING).addComponent(this.jSpinner_Precision)).addContainerGap()));
        jPanel_FieldPropLayout.setVerticalGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_FieldPropLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField_Name, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBox_Type, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jSpinner_Width, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jSpinner_Precision, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_FieldPropLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField_MissingValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(67, 67, 67).addComponent(this.jButton_AddData).addGap(67, 67, 67).addComponent(this.jButton_Cancel).addGap(65, 65, 65)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel_SelFields, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton_InputFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_InputFile)).addComponent(this.jPanel_FieldProp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_InputFile).addComponent(this.jTextField_InputFile, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel_SelFields, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel_FieldProp, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_AddData).addComponent(this.jButton_Cancel)).addContainerGap()));
        this.pack();
    }

    private void jButton_InputFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"csv", "txt"};
        GenericFileFilter allFileFilter = new GenericFileFilter(fileExts, "Supported Formats");
        aDlg.addChoosableFileFilter((FileFilter)allFileFilter);
        fileExts = new String[]{"csv"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "CSV File (*.csv)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"txt"};
        mapFileFilter = new GenericFileFilter(fileExts, "Text File (*.txt)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        aDlg.setFileFilter((FileFilter)allFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            this.infile = aDlg.getSelectedFile();
            System.setProperty("user.dir", this.infile.getParent());
            this.jTextField_InputFile.setText(this.infile.getAbsolutePath());
            try {
                BufferedReader sr = new BufferedReader(new FileReader(this.infile));
                String title = sr.readLine();
                String[] titleArray = title.split(",");
                if (titleArray.length <= 1) {
                    JOptionPane.showMessageDialog(null, "File Format Error!");
                } else {
                    this.jPanel_SelFields.setEnabled(true);
                    this.jComboBox_StartDateField.removeAllItems();
                    this.jComboBox_EndDateField.removeAllItems();
                    this.jComboBox_DataField.removeAllItems();
                    this.jComboBox_EndDateField.addItem("Null");
                    for (int i = 0; i < titleArray.length; ++i) {
                        this.jComboBox_StartDateField.addItem(titleArray[i]);
                        this.jComboBox_EndDateField.addItem(titleArray[i]);
                        this.jComboBox_DataField.addItem(titleArray[i]);
                    }
                }
                sr.close();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_AddDataActionPerformed(ActionEvent evt) {
        BufferedReader sr = null;
        try {
            int sDateFldIdx = this.jComboBox_StartDateField.getSelectedIndex();
            int eDateFldIdx = this.jComboBox_EndDateField.getSelectedIndex();
            int dataFldIdx = this.jComboBox_DataField.getSelectedIndex();
            String formatStr = this.jComboBox_DateFormat.getSelectedItem().toString();
            DateTimeFormatter format = DateTimeFormatter.ofPattern(formatStr);
            String timeZoneStr = this.jComboBox_TimeZone.getSelectedItem().toString();
            int timeZone = this.getTimeZone(timeZoneStr);
            String mvalueStr = this.jTextField_MissingValue.getText();
            this.undef = Double.parseDouble(mvalueStr);
            if (eDateFldIdx == 0) {
                ArrayList<String[]> myDataList = new ArrayList<String[]>();
                sr = new BufferedReader(new FileReader(this.infile));
                sr.readLine();
                String aDataStr = sr.readLine();
                while (aDataStr != null) {
                    String[] aDataArray = aDataStr.split(",");
                    if (aDataArray.length > Math.max(sDateFldIdx, dataFldIdx)) {
                        String[] theData = new String[]{aDataArray[sDateFldIdx], aDataArray[dataFldIdx]};
                        myDataList.add(theData);
                    }
                    aDataStr = sr.readLine();
                }
                sr.close();
                int N = myDataList.size();
                if (N == 0) {
                    JOptionPane.showMessageDialog(null, "No data was extracted from the file!");
                    return;
                }
                GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
                FrmMultiSel frmMultiSel = new FrmMultiSel((Frame)((JFrame)this.app), true);
                frmMultiSel.setTitle("Select Layers");
                frmMultiSel.setLabelText("Layers:");
                DefaultListModel listModel = new DefaultListModel();
                for (LayerNode lNode : gNode.getLayers()) {
                    listModel.addElement(new CheckBoxListEntry((Object)lNode.getMapLayer(), true));
                }
                frmMultiSel.setListModel(listModel);
                frmMultiSel.setLocationRelativeTo((JFrame)this.app);
                frmMultiSel.setVisible(true);
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                if (frmMultiSel.isOK()) {
                    int i;
                    listModel = frmMultiSel.getListModel();
                    for (i = 0; i < listModel.getSize(); ++i) {
                        if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                        layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
                    }
                    if (layers.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "No layer was selected!");
                        return;
                    }
                    this.app.getProgressBar().setVisible(true);
                    this.app.getProgressBar().setValue(0);
                    this.app.getProgressBarLabel().setVisible(true);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    String fldName = this.jTextField_Name.getText();
                    DataType aType = (DataType)this.jComboBox_Type.getSelectedItem();
                    int fLen = (Integer)this.jSpinner_Width.getValue();
                    int fDec = (Integer)this.jSpinner_Precision.getValue();
                    for (VectorLayer layer : layers) {
                        int j;
                        String aDateStr;
                        LocalDateTime dt;
                        this.app.getProgressBarLabel().setText(layer.getLayerName());
                        int CFldIdx = layer.getFieldIdxByName(fldName);
                        if (CFldIdx == -1) {
                            Field fld = new Field(fldName, aType, fLen, fDec);
                            layer.editAddField(fld);
                            CFldIdx = layer.getFieldNumber() - 1;
                        }
                        int sNum = layer.getShapeNum();
                        int dateIdx = layer.getFieldIdxByName("Date");
                        if (dateIdx > -1) {
                            for (i = 0; i < sNum; ++i) {
                                dt = (LocalDateTime)layer.getCellValue("Date", i);
                                int hour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                                dt = dt.withHour(hour);
                                dt = dt.plusHours(timeZone);
                                aDateStr = format.format(dt);
                                Object value = this.undef;
                                switch (aType) {
                                    case INT: {
                                        value = (int)this.undef;
                                        break;
                                    }
                                    case STRING: {
                                        value = "Null";
                                    }
                                }
                                layer.editCellValue(CFldIdx, i, value);
                                for (j = 0; j < N; ++j) {
                                    int tlen = ((String[])myDataList.get(j))[0].length();
                                    String dstr = tlen <= aDateStr.length() ? aDateStr.substring(0, tlen) : aDateStr;
                                    if (!dstr.equals(((String[])myDataList.get(j))[0])) continue;
                                    String dStr = ((String[])myDataList.get(j))[1];
                                    value = dStr;
                                    switch (aType) {
                                        case INT: {
                                            if (dStr.isEmpty()) {
                                                value = (int)this.undef;
                                                break;
                                            }
                                            value = Integer.parseInt(dStr);
                                            break;
                                        }
                                        case DOUBLE: {
                                            value = dStr.isEmpty() ? Double.valueOf(this.undef) : Double.valueOf(Double.parseDouble(dStr));
                                        }
                                    }
                                    layer.editCellValue(CFldIdx, i, value);
                                    break;
                                }
                                this.app.getProgressBar().setValue((int)(((double)i + 1.0) / (double)sNum * 100.0));
                            }
                        } else {
                            block49: for (i = 0; i < sNum; ++i) {
                                int aYear = Integer.parseInt(layer.getCellValue("Year", i).toString());
                                int aMonth = Integer.parseInt(layer.getCellValue("Month", i).toString());
                                int aDay = Integer.parseInt(layer.getCellValue("Day", i).toString());
                                int aHour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                                dt = LocalDateTime.of(aYear, aMonth, dateIdx, aDay, aHour);
                                dt = dt.plusHours(timeZone);
                                aDateStr = format.format(dt);
                                for (j = 0; j <= N - 1; ++j) {
                                    int tlen = ((String[])myDataList.get(j))[0].length();
                                    String dstr = tlen <= aDateStr.length() ? aDateStr.substring(0, tlen) : aDateStr;
                                    if (!dstr.equals(((String[])myDataList.get(j))[0])) continue;
                                    layer.editCellValue(CFldIdx, i, (Object)((String[])myDataList.get(j))[1]);
                                    continue block49;
                                }
                            }
                        }
                        layer.getAttributeTable().save();
                    }
                }
            } else {
                --eDateFldIdx;
                ArrayList<Object[]> myDataList = new ArrayList<Object[]>();
                sr = new BufferedReader(new FileReader(this.infile));
                int N = 0;
                sr.readLine();
                String aDataStr = sr.readLine();
                while (aDataStr != null) {
                    String[] aDataArray = aDataStr.split(",");
                    if (aDataArray.length > Math.max(sDateFldIdx, dataFldIdx)) {
                        Object[] theData = new Object[]{format.parse(aDataArray[sDateFldIdx]), format.parse(aDataArray[eDateFldIdx]), aDataArray[dataFldIdx]};
                        myDataList.add(theData);
                    }
                    aDataStr = sr.readLine();
                }
                sr.close();
                N = myDataList.size();
                if (N == 0) {
                    JOptionPane.showMessageDialog(null, "No data was extracted from the file!");
                    return;
                }
                GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
                FrmMultiSel frmMultiSel = new FrmMultiSel((Frame)((JFrame)this.app), true);
                frmMultiSel.setTitle("Select Layers");
                frmMultiSel.setLabelText("Layers:");
                DefaultListModel listModel = new DefaultListModel();
                for (LayerNode lNode : gNode.getLayers()) {
                    listModel.addElement(new CheckBoxListEntry((Object)lNode.getMapLayer(), true));
                }
                frmMultiSel.setListModel(listModel);
                frmMultiSel.setLocationRelativeTo((JFrame)this.app);
                frmMultiSel.setVisible(true);
                ArrayList layers = new ArrayList();
                if (frmMultiSel.isOK()) {
                    int i;
                    listModel = frmMultiSel.getListModel();
                    for (i = 0; i < listModel.getSize(); ++i) {
                        if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                        layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
                    }
                    if (layers.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "No layer was selected!");
                        return;
                    }
                    this.app.getProgressBar().setVisible(true);
                    this.app.getProgressBar().setValue(0);
                    this.app.getProgressBarLabel().setVisible(true);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    String fldName = this.jTextField_Name.getText();
                    DataType aType = (DataType)this.jComboBox_Type.getSelectedItem();
                    int fLen = (Integer)this.jSpinner_Width.getValue();
                    int fDec = (Integer)this.jSpinner_Precision.getValue();
                    Iterator iterator = layers.iterator();
                    while (iterator.hasNext()) {
                        VectorLayer layer = (VectorLayer)iterator.next();
                        this.app.getProgressBarLabel().setText(layer.getLayerName());
                        int CFldIdx = layer.getFieldIdxByName(fldName);
                        if (CFldIdx == -1) {
                            Field fld = new Field(fldName, aType, fLen, fDec);
                            layer.editAddField(fld);
                            CFldIdx = layer.getFieldNumber() - 1;
                        }
                        int sNum = layer.getShapeNum();
                        for (i = 0; i < sNum; ++i) {
                            LocalDateTime aDate = (LocalDateTime)layer.getCellValue("Date", i);
                            int hour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                            aDate = aDate.withHour(hour);
                            aDate = aDate.plusHours(timeZone);
                            Object value = this.undef;
                            switch (aType) {
                                case INT: {
                                    value = (int)this.undef;
                                    break;
                                }
                                case STRING: {
                                    value = "Null";
                                }
                            }
                            layer.editCellValue(CFldIdx, i, value);
                            for (int j = 0; j < N; ++j) {
                                LocalDateTime sdate = (LocalDateTime)((Object[])myDataList.get(j))[0];
                                LocalDateTime edate = (LocalDateTime)((Object[])myDataList.get(j))[1];
                                if (!aDate.equals(sdate) && !aDate.isAfter(sdate) || !aDate.isBefore(edate)) continue;
                                String dStr = ((Object[])myDataList.get(j))[2].toString();
                                value = dStr;
                                switch (aType) {
                                    case INT: {
                                        if (dStr.isEmpty()) {
                                            value = (int)this.undef;
                                            break;
                                        }
                                        value = Integer.parseInt(dStr);
                                        break;
                                    }
                                    case DOUBLE: {
                                        value = dStr.isEmpty() ? Double.valueOf(this.undef) : Double.valueOf(Double.parseDouble(dStr));
                                    }
                                }
                                layer.editCellValue(CFldIdx, i, value);
                                break;
                            }
                            this.app.getProgressBar().setValue((int)(((double)i + 1.0) / (double)sNum * 100.0));
                        }
                        layer.getAttributeTable().save();
                    }
                }
            }
            this.app.getProgressBar().setVisible(false);
            this.app.getProgressBarLabel().setVisible(false);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBox_DataFieldActionPerformed(ActionEvent evt) {
        if (this.jComboBox_DataField.getItemCount() == 0) {
            return;
        }
        this.jPanel_FieldProp.setEnabled(true);
        this.jTextField_Name.setText(this.jComboBox_DataField.getSelectedItem().toString());
        if (Character.isDigit(this.jTextField_Name.getText().charAt(0))) {
            this.jTextField_Name.setText("A" + this.jTextField_Name.getText());
        }
        if (!this.jButton_AddData.isEnabled()) {
            this.jButton_AddData.setEnabled(true);
        }
    }

    private void jComboBox_TypeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Type.getItemCount() > 0) {
            switch ((DataType)this.jComboBox_Type.getSelectedItem()) {
                case INT: {
                    this.jSpinner_Width.setValue(8);
                    this.jSpinner_Precision.setValue(0);
                    this.jSpinner_Precision.setVisible(false);
                    break;
                }
                case DOUBLE: {
                    this.jSpinner_Width.setValue(10);
                    this.jSpinner_Precision.setValue(4);
                    this.jSpinner_Precision.setVisible(true);
                    break;
                }
                case STRING: {
                    this.jSpinner_Width.setValue(20);
                    this.jSpinner_Precision.setValue(0);
                    this.jSpinner_Precision.setVisible(false);
                }
            }
        }
    }

    private String getTimeZoneString(int timeZone) {
        if (timeZone >= 0) {
            return "GMT+" + String.valueOf(timeZone);
        }
        return "GMT" + String.valueOf(timeZone);
    }

    private int getTimeZone(String timeZoneStr) {
        String str = (timeZoneStr = timeZoneStr.trim()).substring(3);
        if (str.charAt(0) == '+') {
            str = str.substring(1);
        }
        int tz = Integer.parseInt(str);
        return tz;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmAddData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmAddData dialog = new FrmAddData((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

