/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.chart.ChartLegend;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.MouseMode;
import org.meteoinfo.chart.graphic.GraphicFactory;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.Plot2D;
import org.meteoinfo.chart.plot.Plot3D;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geo.io.GraphicUtil;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geo.mapview.MouseTools;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.ui.event.IShapeSelectedListener;
import org.meteoinfo.ui.event.ShapeSelectedEvent;
import org.meteothink.trajstat.forms.FrmClusterCal;

public class FrmChart
extends JDialog {
    private IApplication app;
    private JToolBar toolBar;
    private ChartPanel chartPanel;
    private Chart chart;
    private JButton button_Sel;
    private JButton button_Remove;
    private JButton button_RemoveAll;
    private JToggleButton button_3D;
    private List<String> dateHeight = new ArrayList<String>();
    private List<Object[]> trajShapes = new ArrayList<Object[]>();
    private List<MapLayer> mLayers = new ArrayList<MapLayer>();
    private boolean isSingleLegend = true;

    public FrmChart(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (parent != null) {
            this.app = (IApplication)parent;
            this.app.getMapDocument().getActiveMapFrame().getMapView().addShapeSelectedListener(new IShapeSelectedListener(){

                public void shapeSelectedEvent(ShapeSelectedEvent event) {
                    FrmChart.this.onShapeSelected();
                }
            });
        }
        this.setTitle("Pressure profile plot");
        if (parent != null) {
            this.updateMaplayers();
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/TrajStat_Logo.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(image);
        if (parent != null) {
            this.button_Sel.doClick();
        }
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.chartPanel = new ChartPanel(null);
        this.button_Sel = new JButton();
        this.button_Remove = new JButton();
        this.button_RemoveAll = new JButton();
        this.button_3D = new JToggleButton();
        this.setDefaultCloseOperation(2);
        this.setSize(800, 400);
        ClassLoader classLoader = FrmChart.class.getClassLoader();
        this.button_Sel.setIcon((Icon)new FlatSVGIcon("org/meteothink/trajstat/icons/select.svg", classLoader));
        this.button_Sel.setToolTipText("Select Trajectory");
        this.button_Sel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmChart.this.onSelTrajClick(e);
            }
        });
        this.toolBar.add(this.button_Sel);
        this.button_Remove.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/remove.svg"));
        this.button_Remove.setToolTipText("Remove Last Trajectory");
        this.button_Remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmChart.this.onRemoveClick(e);
            }
        });
        this.toolBar.add(this.button_Remove);
        this.button_RemoveAll.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/delete.svg"));
        this.button_RemoveAll.setToolTipText("Remove All Trajectories");
        this.button_RemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmChart.this.onRemoveAllClick(e);
            }
        });
        this.toolBar.add(this.button_RemoveAll);
        this.toolBar.addSeparator();
        this.button_3D.setIcon((Icon)new FlatSVGIcon("org/meteothink/trajstat/icons/figure-3d.svg", classLoader));
        this.button_3D.setToolTipText("3D view");
        this.button_3D.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FrmChart.this.on3DChange(e);
            }
        });
        this.toolBar.add(this.button_3D);
        this.add((Component)this.toolBar, "North");
        this.chartPanel.setBackground(Color.white);
        this.chart = new Chart();
        this.chartPanel.setChart(this.chart);
        this.add((Component)this.chartPanel, "Center");
    }

    private void updateMaplayers() {
        GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Geo Data");
        if (gNode == null) {
            JOptionPane.showMessageDialog(this, "The layer group not found: Geo Data");
            return;
        }
        this.mLayers.clear();
        for (LayerNode layerNode : gNode.getLayers()) {
            if (!layerNode.getMapLayer().isVisible()) continue;
            this.mLayers.add(layerNode.getMapLayer());
        }
    }

    private void onSelTrajClick(ActionEvent e) {
        this.app.setCurrentTool((AbstractButton)((JButton)e.getSource()));
        this.app.getMapDocument().getActiveMapFrame().getMapView().setMouseTool(MouseTools.SELECT_FEATURES_RECTANGLE);
    }

    private void onShapeSelected() {
        VectorLayer trajLayer = (VectorLayer)this.app.getMapDocument().getActiveMapFrame().getMapView().getSelectedLayer();
        if (trajLayer != null && trajLayer.getShapeType() == ShapeTypes.POLYLINE_Z) {
            this.isSingleLegend = trajLayer.getLegendScheme().getLegendType() != LegendType.UNIQUE_VALUE;
            int n = 0;
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHH");
            for (int i = 0; i < trajLayer.getShapeNum(); ++i) {
                if (!((Shape)trajLayer.getShapes().get(i)).isSelected()) continue;
                if (trajLayer.getFieldIdxByName("Date") >= 0) {
                    LocalDateTime aDate = (LocalDateTime)trajLayer.getCellValue("Date", i);
                    int hour = Integer.parseInt(trajLayer.getCellValue("Hour", i).toString());
                    aDate = aDate.withHour(hour);
                    String dhstr = df.format(aDate);
                    float height = ((Float)trajLayer.getCellValue("Height", i)).floatValue();
                    if (this.dateHeight.contains(dhstr = dhstr + "_" + String.valueOf(height))) continue;
                    this.dateHeight.add(dhstr);
                }
                PolylineZShape aPLZ = (PolylineZShape)trajLayer.getShapes().get(i);
                ColorBreak cb = (ColorBreak)trajLayer.getLegendScheme().getLegendBreaks().get(aPLZ.getLegendIndex());
                this.trajShapes.add(new Object[]{aPLZ, cb});
                ++n;
            }
            if (n > 0) {
                this.updateChart();
            }
        }
    }

    private void updateChart() {
        if (this.trajShapes.isEmpty()) {
            this.chartPanel.getChart().clearPlots();
            this.chartPanel.paintGraphics();
            return;
        }
        Plot2D plot = new Plot2D();
        int trajN = this.trajShapes.size();
        LegendScheme ls = null;
        if (this.isSingleLegend) {
            ls = LegendManage.createUniqValueLegendScheme((int)trajN, (ShapeTypes)ShapeTypes.POLYLINE);
            for (ColorBreak cb : ls.getLegendBreaks()) {
                PolylineBreak plb = (PolylineBreak)cb;
                plb.setDrawSymbol(true);
                plb.setSymbolInterval(6);
                plb.setWidth(2.0f);
            }
        }
        ArrayList<ColorBreak> cbs = new ArrayList<ColorBreak>();
        for (int i = 0; i < trajN; ++i) {
            ColorBreak cb;
            PolylineZShape shape = (PolylineZShape)this.trajShapes.get(i)[0];
            String seriesKey = this.dateHeight.size() > 0 && this.dateHeight.size() > i ? this.dateHeight.get(i) : "Line " + String.valueOf(i);
            int n = shape.getPointNum();
            Array xdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            Array ydata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int j = 0; j < n; ++j) {
                xdata.setDouble(j, (double)j);
                ydata.setDouble(j, ((PointZ)shape.getPoints().get((int)j)).M);
            }
            if (ls == null) {
                cb = (ColorBreak)this.trajShapes.get(i)[1];
            } else {
                cb = ls.getLegendBreak(i);
                cb.setCaption(seriesKey);
            }
            cbs.add(cb);
            GraphicCollection gg = GraphicFactory.createLineString((Array)xdata, (Array)ydata, (ColorBreak)cb);
            plot.addGraphic((Graphic)gg);
        }
        plot.setAutoExtent();
        plot.setDrawLegend(true);
        plot.getGridLine().setDrawXLine(true);
        plot.getGridLine().setDrawYLine(true);
        plot.getXAxis().setInverse(false);
        plot.getYAxis().setInverse(true);
        ChartText text = new ChartText("Age Hour");
        text.setXAlign(XAlign.CENTER);
        text.setYAlign(YAlign.TOP);
        plot.getXAxis().setLabel(text);
        text = new ChartText("hPa");
        text.setAngle(90.0f);
        text.setXAlign(XAlign.LEFT);
        text.setYAlign(YAlign.BOTTOM);
        plot.getYAxis().setLabel(text);
        if (ls == null) {
            ls = new LegendScheme(ShapeTypes.POLYLINE);
            ls.setLegendBreaks(cbs);
        }
        ChartLegend legend = new ChartLegend(ls);
        plot.addLegend(legend);
        this.chart.clearPlots();
        this.chart.addPlot((Plot)plot);
        this.chartPanel.setMouseMode(MouseMode.SELECT);
        this.chartPanel.paintGraphics();
    }

    private void updateChart3D() {
        ChartText text;
        if (this.trajShapes.isEmpty()) {
            this.chartPanel.getChart().clearPlots();
            this.chartPanel.paintGraphics();
            return;
        }
        Plot3D plot = new Plot3D();
        plot.getGridLine().setDrawXLine(true);
        plot.getGridLine().setDrawYLine(true);
        plot.getGridLine().setDrawZLine(true);
        for (MapLayer layer : this.mLayers) {
            Object gcs;
            if (layer.getLayerType() == LayerTypes.VECTOR_LAYER) {
                gcs = GraphicUtil.layerToGraphics((VectorLayer)((VectorLayer)layer), (double)0.0, (double)0.0);
                plot.addGraphic((Graphic)gcs);
                continue;
            }
            gcs = GraphicUtil.layerToGraphics((ImageLayer)((ImageLayer)layer), (double)0.0, (double)0.0, null);
            plot.addGraphic((Graphic)gcs);
        }
        int trajN = this.trajShapes.size();
        LegendScheme ls = null;
        if (this.isSingleLegend) {
            ls = LegendManage.createUniqValueLegendScheme((int)trajN, (ShapeTypes)ShapeTypes.POLYLINE);
            for (ColorBreak cb : ls.getLegendBreaks()) {
                PolylineBreak plb = (PolylineBreak)cb;
                plb.setDrawSymbol(true);
                plb.setSymbolInterval(6);
                plb.setWidth(2.0f);
            }
        }
        Extent3D extent = new Extent3D();
        ArrayList<ColorBreak> cbs = new ArrayList<ColorBreak>();
        int idx = 0;
        Array sx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{trajN});
        Array sy = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{trajN});
        Array sz = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{trajN});
        for (int i = 0; i < trajN; ++i) {
            ColorBreak cb;
            PolylineZShape shape = (PolylineZShape)this.trajShapes.get(i)[0];
            String seriesKey = this.dateHeight.size() > 0 && this.dateHeight.size() > i ? this.dateHeight.get(i) : "Line " + String.valueOf(i);
            PointZ ppz = (PointZ)shape.getPoints().get(0);
            sx.setDouble(i, ppz.X);
            sy.setDouble(i, ppz.Y);
            sz.setDouble(i, ppz.Z);
            if (ls == null) {
                cb = (ColorBreak)this.trajShapes.get(i)[1];
            } else {
                cb = ls.getLegendBreak(i);
                cb.setCaption(seriesKey);
            }
            cbs.add(cb);
            for (Polyline line : shape.getPolylines()) {
                int n = line.getPointList().size();
                Array xdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
                Array ydata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
                Array zdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
                for (int j = 0; j < n; ++j) {
                    PointZ pz = (PointZ)line.getPointList().get(j);
                    xdata.setDouble(j, pz.X);
                    ydata.setDouble(j, pz.Y);
                    zdata.setDouble(j, pz.Z);
                }
                GraphicCollection gg = GraphicFactory.createLineString3D((Array)xdata, (Array)ydata, (Array)zdata, (ColorBreak)cb);
                plot.addGraphic((Graphic)gg);
                extent = idx == 0 ? (Extent3D)gg.getExtent() : extent.union((Extent3D)gg.getExtent());
                ++idx;
            }
        }
        PointBreak pb = new PointBreak();
        pb.setStyle(PointStyle.STAR);
        pb.setColor(Color.red);
        pb.setSize(14.0f);
        GraphicCollection gg = GraphicFactory.createPoints3D((Array)sx, (Array)sy, (Array)sz, (ColorBreak)pb);
        plot.addGraphic((Graphic)gg);
        extent = extent.extend(0.2);
        extent.minZ = 0.0;
        plot.setExtent(extent);
        ProjectionInfo proj = this.app.getMapDocument().getActiveMapFrame().getMapView().getProjection().getProjInfo();
        if (proj.isLonLat()) {
            text = new ChartText();
            text.setText("Longitude");
            text.setXAlign(XAlign.CENTER);
            text.setYAlign(YAlign.BOTTOM);
            plot.getXAxis().setLabel(text);
            text = new ChartText();
            text.setText("Latitude");
            text.setXAlign(XAlign.LEFT);
            text.setYAlign(YAlign.CENTER);
            plot.getYAxis().setLabel(text);
        }
        text = new ChartText();
        text.setText("Height (Meter)");
        text.setXAlign(XAlign.CENTER);
        text.setYAlign(YAlign.BOTTOM);
        plot.getZAxis().setLabel(text);
        if (ls == null) {
            ls = new LegendScheme(ShapeTypes.POLYLINE);
            ls.setLegendBreaks(cbs);
        }
        ChartLegend legend = new ChartLegend(ls);
        legend.setYShift(25.0f);
        plot.addLegend(legend);
        plot.setPosition(0.13, 0.15, 0.71, 0.815);
        this.chart.clearPlots();
        this.chart.addPlot((Plot)plot);
        this.chartPanel.setMouseMode(MouseMode.ROTATE);
        this.chartPanel.paintGraphics();
    }

    private void onRemoveClick(ActionEvent e) {
        if (this.trajShapes.size() > 0) {
            this.trajShapes.remove(this.trajShapes.size() - 1);
            this.dateHeight.remove(this.dateHeight.size() - 1);
            this.updateChart();
        }
    }

    private void onRemoveAllClick(ActionEvent e) {
        if (this.trajShapes.size() > 0) {
            this.trajShapes.clear();
            this.dateHeight.clear();
            this.updateChart();
        }
    }

    private void on3DChange(ChangeEvent e) {
        if (this.button_3D.isSelected()) {
            this.updateChart3D();
        } else {
            this.updateChart();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmClusterCal.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmChart dialog = new FrmChart(null, true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

