/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.meteoinfo.map.config.GenericFileFilter;

public class ImageFileChooser
extends JFileChooser {
    JComboBox dpiCB = new JComboBox();
    JPanel panel;

    public ImageFileChooser() {
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
        cbm.addElement("Default");
        cbm.addElement("150");
        cbm.addElement("300");
        cbm.addElement("600");
        cbm.addElement("900");
        cbm.addElement("1200");
        this.dpiCB.setModel(cbm);
        this.dpiCB.setEditable(true);
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 10, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panel.add((Component)new JLabel("DPI:"), constraints);
        constraints.gridy = 1;
        this.panel.add((Component)this.dpiCB, constraints);
        this.setAccessory(this.panel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                GenericFileFilter filter;
                String prop = pce.getPropertyName();
                if ("fileFilterChanged".equals(prop) && (filter = (GenericFileFilter)pce.getNewValue()) != null) {
                    switch (filter.getFileExtent().toLowerCase()) {
                        case "png": 
                        case "jpg": 
                        case "bmp": 
                        case "gif": 
                        case "tif": {
                            ImageFileChooser.this.panel.setVisible(true);
                            break;
                        }
                        default: {
                            ImageFileChooser.this.panel.setVisible(false);
                        }
                    }
                    ImageFileChooser.this.repaint();
                }
            }
        });
    }

    public Integer getDPI() {
        if (!this.dpiCB.isVisible()) {
            return null;
        }
        String dpiStr = this.dpiCB.getSelectedItem().toString();
        if (dpiStr.equals("Default")) {
            return null;
        }
        return Integer.parseInt(dpiStr);
    }
}

