/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.SortedMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.meteoinfo.common.io.IOUtil;

public class ShapeFileChooser
extends JFileChooser {
    JComboBox encodingCB = new JComboBox();
    JPanel panel;

    public ShapeFileChooser() {
        SortedMap<String, Charset> m = Charset.availableCharsets();
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
        cbm.addElement("System");
        for (String n : m.keySet()) {
            Charset e = (Charset)m.get(n);
            cbm.addElement(e.displayName());
        }
        this.encodingCB.setModel(cbm);
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 10, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panel.add((Component)new JLabel("Encoding:"), constraints);
        constraints.gridy = 1;
        this.panel.add((Component)this.encodingCB, constraints);
        this.setAccessory(this.panel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                File file;
                String prop = pce.getPropertyName();
                if ("SelectedFileChangedProperty".equals(prop) && (file = (File)pce.getNewValue()) != null && file.isFile()) {
                    String fn = file.getAbsolutePath();
                    if (fn.toLowerCase().endsWith(".shp")) {
                        String encoding = IOUtil.encodingDetectShp((String)fn);
                        if (encoding.equals("ISO8859_1")) {
                            encoding = "UTF-8";
                        }
                        ShapeFileChooser.this.encodingCB.setSelectedItem(encoding);
                        ShapeFileChooser.this.panel.setVisible(true);
                    } else {
                        ShapeFileChooser.this.panel.setVisible(false);
                    }
                    ShapeFileChooser.this.repaint();
                }
            }
        });
    }

    public String getEncoding() {
        String encoding = this.encodingCB.getSelectedItem().toString();
        if (encoding.equals("System")) {
            encoding = Charset.defaultCharset().displayName();
        }
        return encoding;
    }
}

