/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.math.interpolate.NearestNDInterpolator;
import org.meteoinfo.math.spatial.KDTree;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class IDWNDInterpolator
extends NearestNDInterpolator {
    private double radius = Double.NaN;
    private int pointNum = this.kdTree.size();
    private int weightPower = 1;

    public IDWNDInterpolator(List<Array> points, Array values) {
        super(points, values);
    }

    public IDWNDInterpolator(Array points, Array values) {
        super(points, values);
    }

    @Override
    public void setRadius(double value) {
        this.radius = value;
    }

    public void setPointNum(int value) {
        this.pointNum = value;
    }

    public void setWeightPower(int value) {
        this.weightPower = value;
    }

    private void interpolateNeighbours(Array r, List<Array> location, int offset, int endSeg) {
        int n = location.size();
        for (int i = offset; i < endSeg; ++i) {
            ArrayList srs = this.kdTree.nearestNeighbours(this.getCoordinate(location, n, i), this.pointNum);
            double v_sum = 0.0;
            double weight_sum = 0.0;
            boolean match = false;
            for (KDTree.SearchResult searchResult : srs) {
                double v = (Double)searchResult.payload;
                if (searchResult.distance == 0.0) {
                    r.setDouble(i, v);
                    match = true;
                    break;
                }
                double w = 1.0 / Math.pow(searchResult.distance, this.weightPower);
                weight_sum += w;
                v_sum += v * w;
            }
            if (match) continue;
            r.setDouble(i, v_sum / weight_sum);
        }
    }

    private void interpolateRadius(Array r, List<Array> location, int offset, int endSeg) {
        int n = location.size();
        for (int i = offset; i < endSeg; ++i) {
            ArrayList srs = this.kdTree.ballSearch_distance(this.getCoordinate(location, n, i), this.radius * this.radius);
            if (srs == null || srs.size() < this.pointNum) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            double v_sum = 0.0;
            double weight_sum = 0.0;
            boolean match = false;
            for (KDTree.SearchResult searchResult : srs) {
                double v = (Double)searchResult.payload;
                if (searchResult.distance == 0.0) {
                    r.setDouble(i, v);
                    match = true;
                    break;
                }
                double w = 1.0 / Math.pow(searchResult.distance, this.weightPower);
                weight_sum += w;
                v_sum += v * w;
            }
            if (match) continue;
            r.setDouble(i, v_sum / weight_sum);
        }
    }

    public Array interpolate(List<Array> location) {
        for (Array a : location) {
            a = a.copyIfView();
        }
        int pNum = (int)location.get(0).getSize();
        Array r = Array.factory((DataType)this.dataType, (int[])location.get(0).getShape());
        if (Double.isNaN(this.radius)) {
            this.interpolateNeighbours(r, location, 0, pNum);
        } else {
            this.interpolateRadius(r, location, 0, pNum);
        }
        return r;
    }

    public Array interpolate(final List<Array> location, int nThreads) {
        for (Array a : location) {
            a = a.copyIfView();
        }
        int pNum = (int)location.get(0).getSize();
        final Array r = Array.factory((DataType)this.dataType, (int[])location.get(0).getShape());
        int segment = pNum / nThreads;
        int remainder = pNum % nThreads;
        int offset = 0;
        ArrayList<1> threads = new ArrayList<1>();
        for (int ti = 0; ti < nThreads; ++ti) {
            int segEnd;
            int segmentSize = remainder-- > 0 ? segment + 1 : segment;
            final int finalSegEnd = segEnd = offset + segmentSize;
            final int finalOffset = offset;
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (Double.isNaN(IDWNDInterpolator.this.radius)) {
                        IDWNDInterpolator.this.interpolateNeighbours(r, location, finalOffset, finalSegEnd);
                    } else {
                        IDWNDInterpolator.this.interpolateRadius(r, location, finalOffset, finalSegEnd);
                    }
                }
            };
            threads.add(t);
            t.start();
            offset += segmentSize;
        }
        for (int i = 0; i < threads.size(); ++i) {
            try {
                ((Thread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return r;
    }
}

