/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.meteoinfo.math.interpolate.InterpolationMethod;
import org.meteoinfo.math.interpolate.RectLinearInterpolator;
import org.meteoinfo.math.interpolate.RectNearestInterpolator;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;

public abstract class RectInterpolator {
    protected Array xa;
    protected Array ya;
    protected Array va;

    public RectInterpolator(Array xa, Array ya, Array va) {
        this.xa = xa.copyIfView();
        this.ya = ya.copyIfView();
        this.va = va;
    }

    public static RectInterpolator factory(Array xa, Array ya, Array va, InterpolationMethod method) {
        if (method == InterpolationMethod.NEAREST) {
            return new RectNearestInterpolator(xa, ya, va);
        }
        return new RectLinearInterpolator(xa, ya, va);
    }

    abstract double cellValue(Index var1, double var2, double var4);

    abstract double interpolate(double var1, double var3);

    public Array interpolate(Array newX, Array newY) {
        newX = newX.copyIfView();
        newY = newY.copyIfView();
        if (this.va.getRank() == 2 && newY.getSize() == newX.getSize()) {
            Array r = Array.factory((DataType)DataType.DOUBLE, (int[])newX.getShape());
            int k = 0;
            while ((long)k < r.getSize()) {
                double y = newY.getDouble(k);
                double x = newX.getDouble(k);
                double v = this.interpolate(x, y);
                r.setDouble(k, v);
                ++k;
            }
            return r;
        }
        int xn = (int)newX.getSize();
        int yn = (int)newY.getSize();
        int[] shape = this.va.getShape();
        int n = shape.length;
        shape[n - 1] = xn;
        shape[n - 2] = yn;
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Index index = r.getIndex();
        int k = 0;
        while ((long)k < r.getSize()) {
            int[] counter = index.getCurrentCounter();
            int yi = counter[n - 2];
            int xi = counter[n - 1];
            double y = newY.getDouble(yi);
            double x = newX.getDouble(xi);
            double v = this.cellValue(index, x, y);
            r.setDouble(index, v);
            index.incr();
            ++k;
        }
        return r;
    }
}

