/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats.regression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math4.legacy.stat.regression.OLSMultipleLinearRegression;

public class StepwiseRegression {
    private static final double F_THRESHOLD = 4.0;

    public static void main(String[] args) {
        double[][] xData = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 4.0, 5.0}, {3.0, 4.0, 5.0, 6.0}, {4.0, 5.0, 6.0, 7.0}, {5.0, 6.0, 7.0, 8.0}};
        double[] yData = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        StepwiseRegression stepwiseRegression = new StepwiseRegression();
        List<Integer> selectedVariables = stepwiseRegression.stepwise(xData, yData);
        System.out.println("Selected Variables: " + selectedVariables);
    }

    public List<Integer> stepwise(double[][] xData, double[] yData) {
        boolean changed;
        ArrayList<Integer> variables = new ArrayList<Integer>();
        for (int i = 0; i < xData[0].length; ++i) {
            variables.add(i);
        }
        ArrayList<Integer> selectedVariables = new ArrayList<Integer>();
        do {
            double fValue;
            ArrayList<Integer> tempVars;
            int var;
            changed = false;
            double bestFValue = Double.NEGATIVE_INFINITY;
            int bestVariable = -1;
            Iterator iterator = variables.iterator();
            while (iterator.hasNext()) {
                var = (Integer)iterator.next();
                if (selectedVariables.contains(var)) continue;
                tempVars = new ArrayList<Integer>(selectedVariables);
                tempVars.add(var);
                fValue = this.calculateFValue(xData, yData, tempVars);
                if (!(fValue > bestFValue)) continue;
                bestFValue = fValue;
                bestVariable = var;
            }
            if (bestFValue > 4.0) {
                selectedVariables.add(bestVariable);
                changed = true;
            }
            bestFValue = Double.NEGATIVE_INFINITY;
            bestVariable = -1;
            iterator = selectedVariables.iterator();
            while (iterator.hasNext()) {
                var = (Integer)iterator.next();
                tempVars = new ArrayList<Integer>(selectedVariables);
                tempVars.remove((Object)var);
                fValue = this.calculateFValue(xData, yData, tempVars);
                if (!(fValue > bestFValue)) continue;
                bestFValue = fValue;
                bestVariable = var;
            }
            if (!(bestFValue > 4.0) || selectedVariables.size() <= 1) continue;
            selectedVariables.remove((Object)bestVariable);
            changed = true;
        } while (changed);
        return selectedVariables;
    }

    private double calculateFValue(double[][] xData, double[] yData, List<Integer> variables) {
        int n = xData.length;
        int k = variables.size();
        double[][] xMatrix = new double[n][k + 1];
        for (int i = 0; i < n; ++i) {
            xMatrix[i][0] = 1.0;
            for (int j = 0; j < k; ++j) {
                xMatrix[i][j + 1] = xData[i][variables.get(j)];
            }
        }
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(yData, xMatrix);
        double sse = regression.calculateResidualSumOfSquares();
        double sst = this.calculateSST(yData);
        double fValue = (sst - sse) / (double)k / (sse / (double)(n - k - 1));
        return fValue;
    }

    private double calculateSST(double[] yData) {
        double mean = 0.0;
        for (double y : yData) {
            mean += y;
        }
        mean /= (double)yData.length;
        double sst = 0.0;
        for (double y : yData) {
            sst += Math.pow(y - mean, 2.0);
        }
        return sst;
    }
}

