/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.console.editor;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.meteoinfo.console.NameCompletion;
import org.meteoinfo.console.Popup;
import org.meteoinfo.console.Tip;

public class MITextEditorPane
extends TextEditorPane {
    private Segment seg;
    private NameCompletion nameCompletion;
    private Popup popup;
    private Tip tip;
    private int dotWidth;
    private int textHeight;
    private final Pattern FROM_PACKAGE_IMPORT = Pattern.compile("from\\s+(\\w+(?:\\.\\w+)*)\\.?(?:\\s*import\\s*)?");

    public MITextEditorPane() {
        this.popup = new Popup(null, (JTextComponent)((Object)this));
        this.tip = new Tip(null);
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        this.dotWidth = metrics.stringWidth(".");
        this.textHeight = metrics.getHeight();
        this.seg = new Segment();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MITextEditorPane.this.type(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (MITextEditorPane.this.popup.isVisible() && e.getID() == 401) {
                    MITextEditorPane.this.popup.type(e);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MITextEditorPane.this.tip.isVisible()) {
                    MITextEditorPane.this.tip.setVisible(false);
                }
                if (MITextEditorPane.this.popup.isVisible()) {
                    MITextEditorPane.this.popup.setVisible(false);
                }
            }
        });
    }

    private synchronized void type(KeyEvent e) {
        if (this.popup.isVisible()) {
            if (e.getID() == 401) {
                this.popup.type(e);
            }
            return;
        }
        switch (e.getKeyCode()) {
            case 46: {
                this.showPopup();
                e.consume();
                break;
            }
            case 32: {
                String command = this.getCurrentText();
                Matcher match = this.FROM_PACKAGE_IMPORT.matcher(command);
                if (match.matches()) {
                    this.showPopup();
                }
                e.consume();
                break;
            }
            case 57: {
                if (e.isShiftDown()) {
                    this.showTip();
                }
                e.consume();
                break;
            }
            case 48: {
                if (e.isShiftDown()) {
                    this.tip.setVisible(false);
                }
                e.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (!this.tip.isVisible()) break;
                this.tip.setVisible(false);
            }
        }
    }

    public void setNameCompletion(NameCompletion value) {
        this.nameCompletion = value;
    }

    private String getCurrentText() {
        Document doc = this.getDocument();
        int dot = this.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        return this.seg.toString();
    }

    private void showPopup() {
        if (this.nameCompletion == null) {
            return;
        }
        String part = this.getCurrentText();
        if (part.length() < 2) {
            return;
        }
        String[] complete = this.nameCompletion.completeName(part);
        if (complete == null) {
            return;
        }
        if (complete.length == 0) {
            return;
        }
        if (complete.length == 1 && !complete.equals(part)) {
            int slen = this.getCaretPosition();
            this.select(slen, slen);
            this.replaceSelection(complete[0]);
            return;
        }
        this.popup.showMethodCompletionList(complete, this.getDisplayPoint());
    }

    private void showTip() {
        String[] callTip;
        String tipstr;
        if (this.nameCompletion == null) {
            return;
        }
        String part = this.getCurrentText();
        if (part.length() < 2) {
            return;
        }
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
        if (!(tipstr = (callTip = this.nameCompletion.getTip(part))[2]).isEmpty()) {
            Point displayPoint = this.getDisplayPoint();
            this.tip.setText(tipstr);
            this.tip.showTip(displayPoint);
        }
    }

    private Point getDisplayPoint() {
        Point screenPoint = this.getLocationOnScreen();
        Point caretPoint = this.getCaret().getMagicCaretPosition();
        if (caretPoint == null) {
            caretPoint = new Point(0, 0);
        }
        int x = (int)(screenPoint.getX() + caretPoint.getX() + (double)this.dotWidth);
        int y = (int)(screenPoint.getY() + caretPoint.getY() + (double)this.textHeight) + 5;
        if (y < 0) {
            y = this.getLocationOnScreen().y;
        }
        return new Point(x, y);
    }
}

