/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.lookandfeel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public class LookAndFeelUtilities {
    public static void updateUI(Collection<Component> components) {
        HashSet<Component> visit = new HashSet<Component>();
        for (Component component : components) {
            Window window = SwingUtilities.getWindowAncestor(component = LookAndFeelUtilities.getAncestor(component));
            if (window != null) {
                LookAndFeelUtilities.change(window, visit);
                continue;
            }
            LookAndFeelUtilities.change(component, visit);
        }
    }

    private static Component getAncestor(Component component) {
        Container parent = component.getParent();
        if (parent == null) {
            return component;
        }
        return LookAndFeelUtilities.getAncestor(parent);
    }

    private static void change(Component base, Set<Component> visit) {
        if (visit.add(base)) {
            SwingUtilities.updateComponentTreeUI(base);
            if (base instanceof Window) {
                Window window = (Window)base;
                for (Window child : window.getOwnedWindows()) {
                    LookAndFeelUtilities.change(child, visit);
                }
            }
        }
    }
}

