/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.console.jython.MyPythonInterpreter;
import org.meteoinfo.lab.Options;
import org.meteoinfo.lab.gui.FrmMain;
import org.meteoinfo.ui.util.FontUtil;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveConsole;
import org.xml.sax.SAXException;

public class MeteoInfoLab {
    public static void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        MeteoInfoLab.disableAccessWarnings();
        if (args.length >= 1 && args[0].equalsIgnoreCase("-r")) {
            String fontPath = GlobalUtil.getAppPath(FrmMain.class) + File.separator + "fonts";
            List fontFns = GlobalUtil.getFiles((String)fontPath, (String)".ttc");
            for (String fontFn : fontFns) {
                System.out.println("Register: " + fontFn);
                FontUtil.registerFont((String)fontFn);
            }
            args = (String[])DataConvert.resizeArray((Object)args, (int)(args.length - 1));
        }
        if (args.length >= 1) {
            File file;
            String fn;
            if (args[0].equalsIgnoreCase("-i")) {
                MeteoInfoLab.runInteractive();
            } else if (args[0].equalsIgnoreCase("-b")) {
                if (args.length == 1) {
                    System.out.println("Script file name is needed!");
                    System.exit(0);
                } else {
                    fn = args[1];
                    file = new File(fn);
                    if (file.isFile()) {
                        System.setProperty("java.awt.headless", "true");
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        System.out.println("Headless mode: " + ge.isHeadless());
                        MeteoInfoLab.runScript(args, file.getCanonicalPath(), 1);
                    } else {
                        System.out.println("The script file does not exist!");
                        System.exit(0);
                    }
                }
            } else if (args[0].equalsIgnoreCase("-eng")) {
                MeteoInfoLab.runApplication(true);
            } else {
                fn = args[0];
                file = new File(fn);
                if (file.isFile()) {
                    MeteoInfoLab.runScript(args, file.getCanonicalPath(), 0);
                } else {
                    System.out.println("The script file does not exist!");
                    System.exit(0);
                }
            }
        } else {
            MeteoInfoLab.runApplication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(String[] args, String fn, int idx) {
        Path path;
        FontUtil.registerWeatherFont();
        System.out.println("Running Jython script: " + fn);
        PySystemState state = new PySystemState();
        if (args.length > idx + 1) {
            for (int i = idx + 1; i < args.length; ++i) {
                state.argv.append((PyObject)Py.newStringOrUnicode((String)args[i]));
            }
        }
        MyPythonInterpreter interp = new MyPythonInterpreter(null, state);
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        String miPath = GlobalUtil.getAppPath(FrmMain.class);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows") && miPath.substring(0, 1).equals("/")) {
            miPath = miPath.substring(1);
        }
        if (miPath.endsWith("classes")) {
            path = new File(miPath).toPath();
            path = path.getParent().getParent();
            miPath = path.toString();
        }
        String pyPath = miPath + File.separator + "pylib";
        String toolboxPath = miPath + File.separator + "toolbox";
        if (miPath.endsWith("meteoinfo-lab")) {
            path = new File(miPath).toPath();
            path = path.getParent();
            path = path.resolve(Paths.get("auxdata", "toolbox"));
            toolboxPath = path.toFile().getAbsolutePath();
        }
        pyPath = pyPath.replace("\\", "/");
        miPath = miPath.replace("\\", "/");
        toolboxPath = toolboxPath.replace("\\", "/");
        try {
            interp.exec("import sys");
            interp.exec("import os");
            interp.exec("import datetime");
            interp.exec("sys.path.append(u'" + pyPath + "')");
            interp.execfile(pyPath + "/milab.py");
            if (!isDebug) {
                interp.exec("sys.path.append(u'" + toolboxPath + "')");
            }
            interp.exec("mipylib.plotlib.miplot.batchmode = True");
            interp.exec("mipylib.migl.interactive = False");
            interp.exec("mipylib.migl.mifolder = u'" + miPath + "'");
            System.out.println("mipylib is loaded...");
            interp.execfile(fn);
            System.out.println("End of run!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void runInteractive() {
        String startPath = System.getProperty("user.dir");
        String miPath = GlobalUtil.getAppPath(FrmMain.class);
        String path = miPath + File.separator + "pylib";
        String toolboxPath = miPath + "/toolbox";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows") && miPath.substring(0, 1).equals("/")) {
            miPath = miPath.substring(1);
        }
        InteractiveConsole console = new InteractiveConsole();
        try {
            console.exec("import sys");
            console.exec("import os");
            console.exec("import datetime");
            console.exec("sys.path.append('" + path + "')");
            console.execfile(path + "/milab.py");
            console.exec("sys.path.append('" + toolboxPath + "')");
            console.exec("mipylib.plotlib.miplot.isinteractive = True");
            console.exec("mipylib.migl.mifolder = '" + miPath + "'");
            console.exec("mipylib.migl.currentfolder = '" + startPath + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        console.interact();
    }

    private static void runApplication() {
        MeteoInfoLab.runApplication(false);
    }

    private static String getStartupPath() {
        String startupPath = GlobalUtil.getAppPath(FrmMain.class);
        if (startupPath.endsWith("classes")) {
            Path path = new File(startupPath).toPath();
            path = path.getParent().getParent();
            startupPath = path.toString();
        }
        return startupPath;
    }

    private static Options loadConfigureFile(String startupPath) {
        String fn = startupPath + File.separator + "milconfig.xml";
        Options options = new Options();
        if (new File(fn).exists()) {
            try {
                options.loadConfigFile(fn);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return options;
    }

    private static void runApplication(final boolean isEng) {
        final String startupPath = MeteoInfoLab.getStartupPath();
        final Options options = MeteoInfoLab.loadConfigureFile(startupPath);
        String laf = options.getLookFeel();
        if (laf.equals("FlatLightLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatDarculaLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatDarculaLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatDarkLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatIntelliJLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatIntelliJLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatMacLightLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatMacLightLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatMacDarkLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatMacDarkLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                String lafName;
                switch (laf) {
                    case "CDE/Motif": {
                        lafName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                        break;
                    }
                    case "Metal": {
                        lafName = "javax.swing.plaf.metal.MetalLookAndFeel";
                        break;
                    }
                    case "Windows": {
                        lafName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                        break;
                    }
                    case "Windows Classic": {
                        lafName = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
                        break;
                    }
                    case "Nimbus": {
                        lafName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                        break;
                    }
                    case "Mac": {
                        lafName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
                        break;
                    }
                    case "GTK": {
                        lafName = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                        break;
                    }
                    default: {
                        lafName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                    }
                }
                UIManager.setLookAndFeel(lafName);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                Logger.getLogger(MeteoInfoLab.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (laf.startsWith("Flat") && options.isLafDecorated()) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (isEng) {
                    Locale.setDefault(Locale.ENGLISH);
                }
                System.out.println("Register weather font...");
                FontUtil.registerWeatherFont();
                System.out.println("Open main form...");
                FrmMain frame = new FrmMain(startupPath, options);
                frame.setDefaultCloseOperation(0);
                frame.setVisible(true);
            }
        });
    }
}

