/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.accept;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.AbstractAcceptance;
import bibliothek.gui.dock.accept.DockAcceptance;

public class CombinatoryAcceptance
extends AbstractAcceptance {
    private Combination combination;
    private DockAcceptance first;
    private DockAcceptance second;

    public CombinatoryAcceptance(Combination combination, DockAcceptance first, DockAcceptance second) {
        this.setCombination(combination);
        this.setFirst(first);
        this.setSecond(second);
    }

    @Override
    public boolean accept(DockStation parent, Dockable child) {
        return this.compare(this.first.accept(parent, child), this.second.accept(parent, child));
    }

    @Override
    public boolean accept(DockStation parent, Dockable child, Dockable next) {
        return this.compare(this.first.accept(parent, child, next), this.second.accept(parent, child, next));
    }

    protected boolean compare(boolean first, boolean second) {
        switch (this.combination) {
            case AND: {
                return first && second;
            }
            case OR: {
                return first || second;
            }
            case XOR: {
                return first != second;
            }
            case EQUAL: {
                return first == second;
            }
            case IMPLIES: {
                return second || !first;
            }
        }
        throw new IllegalStateException("no combination");
    }

    public void setCombination(Combination combination) {
        if (combination == null) {
            throw new IllegalArgumentException("Combination must not be null");
        }
        this.combination = combination;
    }

    public Combination getCombination() {
        return this.combination;
    }

    public void setFirst(DockAcceptance first) {
        if (first == null) {
            throw new IllegalArgumentException("First must not be null");
        }
        this.first = first;
    }

    public DockAcceptance getFirst() {
        return this.first;
    }

    public void setSecond(DockAcceptance second) {
        if (second == null) {
            throw new IllegalArgumentException("Second must not be null");
        }
        this.second = second;
    }

    public DockAcceptance getSecond() {
        return this.second;
    }

    public static enum Combination {
        AND,
        OR,
        XOR,
        EQUAL,
        IMPLIES;

    }
}

