/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.AbstractKeyboardController;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.event.ComponentHierarchyObserverEvent;
import bibliothek.gui.dock.event.ComponentHierarchyObserverListener;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;

public class DefaultKeyboardController
extends AbstractKeyboardController {
    private AWTEventListener awtListener;
    private KeyListener keyListener;
    private ComponentHierarchyObserverListener hierarchyListener;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            DefaultKeyboardController.this.updateRestricted();
        }
    };

    public DefaultKeyboardController(DockController controller, ControllerSetupCollection setup) {
        super(controller);
        setup.add(new ControllerSetupListener(){

            @Override
            public void done(DockController controller) {
                DefaultKeyboardController.this.restricted.setProperties(controller);
                DefaultKeyboardController.this.updateRestricted();
            }
        });
    }

    private void updateRestricted() {
        if (this.restricted.getProperties() != null) {
            boolean restricted = this.restricted.getValue();
            this.setListeningAWT(!restricted);
            this.setListeningKey(restricted);
        }
    }

    private void setListeningAWT(boolean listening) {
        if (listening) {
            if (this.awtListener == null) {
                this.awtListener = this.createAwtListener();
                try {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 8L);
                }
                catch (SecurityException ex) {
                    System.err.println("Can't register AWTEventListener, support for global KeyEvents disabled");
                    ex.printStackTrace();
                }
            }
        } else if (this.awtListener != null) {
            try {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.awtListener = null;
        }
    }

    private void setListeningKey(boolean listening) {
        if (listening) {
            if (this.keyListener == null) {
                this.keyListener = this.createKeyListener();
                this.hierarchyListener = this.createHierarchyListener();
                for (Component component : this.getController().getComponentHierarchyObserver().getComponents()) {
                    component.addKeyListener(this.keyListener);
                }
                this.getController().getComponentHierarchyObserver().addListener(this.hierarchyListener);
            }
        } else if (this.keyListener != null) {
            this.getController().getComponentHierarchyObserver().removeListener(this.hierarchyListener);
            for (Component component : this.getController().getComponentHierarchyObserver().getComponents()) {
                component.removeKeyListener(this.keyListener);
            }
            this.hierarchyListener = null;
            this.keyListener = null;
        }
    }

    @Override
    public void kill() {
        this.setListeningAWT(false);
        this.setListeningKey(false);
        this.restricted.setProperties((DockController)null);
    }

    private AWTEventListener createAwtListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof KeyEvent) {
                    KeyEvent key = (KeyEvent)event;
                    if (key.getID() == 401) {
                        DefaultKeyboardController.this.fireKeyPressed(key);
                    } else if (key.getID() == 402) {
                        DefaultKeyboardController.this.fireKeyReleased(key);
                    } else if (key.getID() == 400) {
                        DefaultKeyboardController.this.fireKeyTyped(key);
                    }
                }
            }
        };
    }

    private KeyListener createKeyListener() {
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                DefaultKeyboardController.this.fireKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DefaultKeyboardController.this.fireKeyReleased(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DefaultKeyboardController.this.fireKeyTyped(e);
            }
        };
    }

    private ComponentHierarchyObserverListener createHierarchyListener() {
        return new ComponentHierarchyObserverListener(){

            @Override
            public void added(ComponentHierarchyObserverEvent event) {
                List<Component> components = event.getComponents();
                if (DefaultKeyboardController.this.keyListener != null) {
                    for (Component component : components) {
                        component.addKeyListener(DefaultKeyboardController.this.keyListener);
                    }
                }
            }

            @Override
            public void removed(ComponentHierarchyObserverEvent event) {
                List<Component> components = event.getComponents();
                if (DefaultKeyboardController.this.keyListener != null) {
                    for (Component component : components) {
                        component.removeKeyListener(DefaultKeyboardController.this.keyListener);
                    }
                }
            }
        };
    }
}

