/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.disable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ActionDisablingStrategyObserver {
    private DockAction action;
    private Map<Dockable, DockableObserver> dockables = new HashMap<Dockable, DockableObserver>();
    private Map<DockController, ControllerObserver> controllers = new HashMap<DockController, ControllerObserver>(1);

    public ActionDisablingStrategyObserver(DockAction action) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.action = action;
    }

    public void bind(Dockable dockable) {
        DockableObserver observer = this.dockables.get(dockable);
        if (observer == null) {
            observer = new DockableObserver(dockable);
            this.dockables.put(dockable, observer);
        }
        observer.inc();
    }

    public void unbind(Dockable dockable) {
        DockableObserver observer = this.dockables.get(dockable);
        if (observer != null) {
            observer.dec();
            if (observer.destroy()) {
                this.dockables.remove(dockable);
            }
        }
    }

    private void set(DockController oldController, DockController newController, Dockable dockable) {
        if (oldController != newController) {
            ControllerObserver observer;
            if (oldController != null) {
                observer = this.controllers.get(oldController);
                observer.remove(dockable);
                if (observer.destroy()) {
                    this.controllers.remove(oldController);
                }
            }
            if (newController != null) {
                observer = this.controllers.get(newController);
                if (observer == null) {
                    observer = new ControllerObserver(newController);
                    this.controllers.put(newController, observer);
                }
                observer.add(dockable);
            }
        }
    }

    protected abstract void setDisabled(Dockable var1, boolean var2);

    protected abstract void setDisabled(Set<Dockable> var1, boolean var2);

    public boolean isDisabled(Dockable dockable) {
        ControllerObserver observer;
        DockController controller = dockable.getController();
        if (controller != null && (observer = this.controllers.get(controller)) != null) {
            return observer.isDisabled(dockable);
        }
        return false;
    }

    private class ControllerObserver
    extends PropertyValue<DisablingStrategy>
    implements DisablingStrategyListener {
        private Set<Dockable> dockables;

        public ControllerObserver(DockController controller) {
            super(DisablingStrategy.STRATEGY);
            this.dockables = new HashSet<Dockable>();
            this.setProperties(controller);
        }

        @Override
        protected void valueChanged(DisablingStrategy oldValue, DisablingStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeDisablingStrategyListener(this);
            }
            if (newValue != null) {
                newValue.addDisablingStrategyListener(this);
                HashSet<Dockable> enabled = new HashSet<Dockable>();
                HashSet<Dockable> disabled = new HashSet<Dockable>();
                for (Dockable item : this.dockables) {
                    if (newValue.isDisabled(item, ActionDisablingStrategyObserver.this.action)) {
                        disabled.add(item);
                        continue;
                    }
                    enabled.add(item);
                }
                if (!enabled.isEmpty()) {
                    ActionDisablingStrategyObserver.this.setDisabled(enabled, false);
                }
                if (!disabled.isEmpty()) {
                    ActionDisablingStrategyObserver.this.setDisabled(disabled, false);
                }
            } else {
                ActionDisablingStrategyObserver.this.setDisabled(this.dockables, false);
            }
        }

        @Override
        public void changed(DockElement item) {
            Dockable dockable = item.asDockable();
            if (dockable != null && this.dockables.contains(dockable)) {
                ActionDisablingStrategyObserver.this.setDisabled(dockable, ((DisablingStrategy)this.getValue()).isDisabled(dockable, ActionDisablingStrategyObserver.this.action));
            }
        }

        public boolean isDisabled(Dockable dockable) {
            DisablingStrategy strategy = (DisablingStrategy)this.getValue();
            if (strategy != null) {
                return strategy.isDisabled(dockable, ActionDisablingStrategyObserver.this.action);
            }
            return false;
        }

        public void add(Dockable dockable) {
            DisablingStrategy strategy = (DisablingStrategy)this.getValue();
            if (strategy != null) {
                ActionDisablingStrategyObserver.this.setDisabled(dockable, strategy.isDisabled(dockable, ActionDisablingStrategyObserver.this.action));
            }
            this.dockables.add(dockable);
        }

        public void remove(Dockable dockable) {
            ActionDisablingStrategyObserver.this.setDisabled(dockable, false);
            this.dockables.remove(dockable);
        }

        public boolean destroy() {
            if (this.dockables.isEmpty()) {
                this.setProperties((DockController)null);
                return true;
            }
            return false;
        }
    }

    private class DockableObserver
    implements DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;
        private int count = 0;

        public DockableObserver(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockHierarchyListener(this);
            DockController controller = dockable.getController();
            if (controller != null) {
                this.bind(controller);
            }
        }

        private void bind(DockController controller) {
            ActionDisablingStrategyObserver.this.set(this.controller, controller, this.dockable);
            this.controller = controller;
        }

        public void inc() {
            ++this.count;
        }

        public void dec() {
            --this.count;
        }

        public boolean destroy() {
            if (this.count <= 0) {
                this.dockable.removeDockHierarchyListener(this);
                this.bind(null);
                return true;
            }
            return false;
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            this.bind(this.dockable.getController());
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }
    }
}

