/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.dockable.ScreencaptureMovingImageFactory;
import bibliothek.gui.dock.dockable.TrueMovingImage;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.SwingUtilities;

public class AncestorMovingImageFactory
extends ScreencaptureMovingImageFactory {
    public AncestorMovingImageFactory(Dimension max, float alpha) {
        super(max, alpha);
    }

    @Override
    public MovingImage create(DockController controller, Dockable dockable) {
        Component[] dockableAncestor = this.ancestors(dockable.getComponent());
        int nearest = dockableAncestor.length + 1;
        Component best = null;
        for (DockTitle title : dockable.listBoundTitles()) {
            int dist;
            int index;
            Component[] titleAncestor = this.ancestors(title.getComponent());
            for (index = 0; index < dockableAncestor.length && index < titleAncestor.length && dockableAncestor[index] == titleAncestor[index]; ++index) {
            }
            if ((dist = dockableAncestor.length - --index) >= nearest) continue;
            nearest = dist;
            best = dockableAncestor[index];
        }
        if (best == null) {
            return super.create(controller, dockable);
        }
        BufferedImage image = this.createImageFrom(controller, best);
        TrueMovingImage moving = new TrueMovingImage();
        moving.setAlpha(this.getAlpha());
        moving.setImage(image);
        return moving;
    }

    private Component[] ancestors(Component component) {
        Component root = SwingUtilities.getRoot(component);
        if (root == component) {
            return new Component[]{component};
        }
        LinkedList<Component> result = new LinkedList<Component>();
        while (root != component) {
            result.add(0, component);
            component = component.getParent();
        }
        result.add(0, root);
        return result.toArray(new Component[result.size()]);
    }
}

