/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.frontend.FrontendDockablePerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCacheExtension;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.screen.ScreenDockPerspective;
import bibliothek.gui.dock.station.split.SplitDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultFrontendPerspectiveCache
implements FrontendPerspectiveCache {
    public static final Path CACHE_EXTENSION = new Path("dock.defaultFrontendPerspectiveCache");
    private Map<PerspectiveElement, String> identifiers = new HashMap<PerspectiveElement, String>();
    private DockFrontend frontend;
    private List<FrontendPerspectiveCacheExtension> extensions;

    public DefaultFrontendPerspectiveCache(DockFrontend frontend) {
        if (frontend == null) {
            throw new IllegalArgumentException("frontend must not be null");
        }
        this.frontend = frontend;
        this.extensions = frontend.getController().getExtensions().load(new ExtensionName<FrontendPerspectiveCacheExtension>(CACHE_EXTENSION, FrontendPerspectiveCacheExtension.class));
    }

    @Override
    public PerspectiveElement get(String id, DockElement element, boolean isRootStation) {
        FrontendPerspectiveCacheExtension extension;
        PerspectiveElement result = null;
        Iterator<FrontendPerspectiveCacheExtension> iterator = this.extensions.iterator();
        while (iterator.hasNext() && (result = (extension = iterator.next()).get(id, element, isRootStation)) == null) {
        }
        if (result == null) {
            if (element instanceof StackDockStation) {
                result = new StackDockPerspective();
            }
            if (element instanceof FlapDockStation) {
                result = new FlapDockPerspective();
            }
            if (element instanceof SplitDockStation) {
                SplitDockPerspective split = new SplitDockPerspective();
                split.setHasFullscreenAction(((SplitDockStation)element).hasFullScreenAction());
                result = split;
            }
            if (element instanceof ScreenDockStation) {
                result = new ScreenDockPerspective();
            }
            if (element instanceof DefaultDockable) {
                result = new FrontendDockablePerspective(id);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("'" + id + "' is of unknown type: " + element);
        }
        if (!element.getFactoryID().equals(result.getFactoryID())) {
            throw new IllegalArgumentException("the factory configured for 'element' is '" + element.getFactoryID() + "', but expected was '" + result.getFactoryID() + "'. Clients need to subclass this cache and handle this special case.");
        }
        this.put(result, id);
        return result;
    }

    protected void put(PerspectiveElement element, String id) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.identifiers.put(element, id);
    }

    @Override
    public PerspectiveElement get(String id, boolean rootStation) {
        return null;
    }

    @Override
    public String get(PerspectiveElement element) {
        for (FrontendPerspectiveCacheExtension extension : this.extensions) {
            String result = extension.get(element);
            if (result == null) continue;
            return result;
        }
        if (element instanceof FrontendDockablePerspective) {
            return ((FrontendDockablePerspective)element).getId();
        }
        return this.identifiers.get(element);
    }

    @Override
    public boolean isRootStation(PerspectiveStation station) {
        String id = this.get(station);
        if (id == null) {
            return false;
        }
        return this.frontend.getRoot(id) != null;
    }
}

