/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StackDockProperty
extends AbstractDockableProperty {
    public static final StackDockProperty FRONT = new StackDockProperty(0);
    public static final StackDockProperty BACK = new StackDockProperty(Integer.MAX_VALUE);
    private int index;
    private Path placeholder;

    public StackDockProperty(int index) {
        this.setIndex(index);
    }

    public StackDockProperty(int index, Path placeholder) {
        this.setIndex(index);
        this.setPlaceholder(placeholder);
    }

    public StackDockProperty() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[index=" + this.index + ", placeholder=" + this.placeholder + ", successor=" + this.getSuccessor() + "]";
    }

    @Override
    public DockableProperty copy() {
        StackDockProperty copy = new StackDockProperty(this.index);
        this.copy(copy);
        return copy;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setPlaceholder(Path placeholder) {
        this.placeholder = placeholder;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public String getFactoryID() {
        return "StackDockPropertyFactory";
    }

    @Override
    public void store(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeInt(this.index);
        if (this.placeholder == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.placeholder.toString());
        }
    }

    @Override
    public void store(XElement element) {
        if (this.index >= 0) {
            element.addElement("index").setInt(this.index);
        }
        if (this.placeholder != null) {
            element.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    @Override
    public void load(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        this.index = in.readInt();
        this.placeholder = null;
        if (version8 && in.readBoolean()) {
            this.placeholder = new Path(in.readUTF());
        }
    }

    @Override
    public void load(XElement element) {
        this.index = -1;
        this.placeholder = null;
        XElement xindex = element.getElement("index");
        XElement xplaceholder = element.getElement("placeholder");
        if (xindex == null && xplaceholder == null) {
            if (element.getValue() != null && element.getValue().length() > 0) {
                this.index = element.getInt();
            }
        } else {
            if (xindex != null) {
                this.index = xindex.getInt();
            }
            if (xplaceholder != null) {
                this.placeholder = new Path(xplaceholder.getString());
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            StackDockProperty other = (StackDockProperty)obj;
            return this.index == other.index;
        }
        return false;
    }
}

