/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.impl.SortDirection;

public class Sorting {
    public static <V> DataFrame sort(DataFrame df, final Map<Integer, SortDirection> cols) {
        Comparator comparator = new Comparator<List<V>>(){

            @Override
            public int compare(List<V> r1, List<V> r2) {
                int result = 0;
                for (Map.Entry col : cols.entrySet()) {
                    int c = (Integer)col.getKey();
                    Object v2 = r2.get(c);
                    if (r1.get(c) instanceof Double && Double.isNaN((Double)r1.get(c))) {
                        result = v2 instanceof Double && Double.isNaN((Double)v2) ? 0 : 1;
                    } else if (v2 instanceof Double && Double.isNaN((Double)v2)) {
                        result = -1;
                    } else {
                        Comparable v1 = (Comparable)Comparable.class.cast(r1.get(c));
                        try {
                            result = v1.compareTo(v2);
                        }
                        catch (Exception e) {
                            result = 1;
                        }
                    }
                    if ((result *= col.getValue() == SortDirection.DESCENDING ? -1 : 1) == 0) continue;
                    break;
                }
                return result;
            }
        };
        return Sorting.sort(df, comparator);
    }

    public static <V> DataFrame sort(final DataFrame df, final Comparator<List<V>> comparator) {
        DataFrame sorted = (DataFrame)df.clone();
        Comparator<Integer> cmp = new Comparator<Integer>(){

            @Override
            public int compare(Integer r1, Integer r2) {
                return comparator.compare(df.row(r1), df.row(r2));
            }
        };
        Integer[] rows = new Integer[df.length()];
        for (int r = 0; r < df.length(); ++r) {
            rows[r] = r;
        }
        Arrays.sort(rows, cmp);
        ArrayList labels = new ArrayList(df.getIndex().getData());
        int i = 0;
        for (Integer r : rows) {
            Integer label = r < labels.size() ? labels.get(r) : r;
            sorted.getIndex().set(i, label);
            for (int c = 0; c < df.size(); ++c) {
                sorted.setValue(i, c, df.getValue((int)r, c));
            }
            ++i;
        }
        return sorted;
    }

    public static <V> DataFrame sortIndex(final DataFrame df, final SortDirection dir) {
        final Comparator comparator = new Comparator<V>(){

            @Override
            public int compare(V v1, V v2) {
                int result = 0;
                Comparable c1 = (Comparable)Comparable.class.cast(v1);
                try {
                    result = c1.compareTo(v2);
                }
                catch (Exception e) {
                    result = 1;
                }
                return result *= dir == SortDirection.DESCENDING ? -1 : 1;
            }
        };
        DataFrame sorted = (DataFrame)df.clone();
        Comparator<Integer> cmp = new Comparator<Integer>(){

            @Override
            public int compare(Integer r1, Integer r2) {
                return comparator.compare(df.getIndex().get(r1), df.getIndex().get(r2));
            }
        };
        Integer[] rows = new Integer[df.length()];
        for (int r = 0; r < df.length(); ++r) {
            rows[r] = r;
        }
        Arrays.sort(rows, cmp);
        ArrayList labels = new ArrayList(df.getIndex().getData());
        int i = 0;
        for (Integer r : rows) {
            Integer label = r < labels.size() ? labels.get(r) : r;
            sorted.getIndex().set(i, label);
            for (int c = 0; c < df.size(); ++c) {
                sorted.setValue(i, c, df.getValue((int)r, c));
            }
            ++i;
        }
        return sorted;
    }
}

