/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.meteothink.imep.verification.MethodType;
import org.meteothink.imep.verification.VerifyTable;

public class ContinuousTable
extends VerifyTable {
    private double[] _fcstValues;
    private double[] _obsValues;

    public ContinuousTable() {
    }

    public ContinuousTable(double[] obs, double[] fcst) {
        this._obsValues = obs;
        this._fcstValues = fcst;
    }

    public ContinuousTable(List<Number> obs, List<Number> fcst) {
        int n = obs.size();
        this._obsValues = new double[n];
        this._fcstValues = new double[n];
        for (int i = 0; i < n; ++i) {
            this._obsValues[i] = obs.get(i).doubleValue();
            this._fcstValues[i] = fcst.get(i).doubleValue();
        }
    }

    public double[] getFcstValues() {
        return this._fcstValues;
    }

    public void setFcstValues(double[] value) {
        this._fcstValues = value;
    }

    public double[] getObsValues() {
        return this._obsValues;
    }

    public void setObsValues(double[] value) {
        this._obsValues = value;
    }

    public int getDataNum() {
        return this._fcstValues.length;
    }

    public double getFsctSum() {
        int n = this.getDataNum();
        double sum = 0.0;
        for (double v : this._fcstValues) {
            sum += v;
        }
        return sum;
    }

    public double getObsSum() {
        int n = this.getDataNum();
        double sum = 0.0;
        for (double v : this._obsValues) {
            sum += v;
        }
        return sum;
    }

    public double getFcstMean() {
        int n = this._fcstValues.length;
        double mean = 0.0;
        for (double v : this._fcstValues) {
            mean += v;
        }
        return mean /= (double)n;
    }

    public double getObsMean() {
        int n = this._fcstValues.length;
        double mean = 0.0;
        for (double v : this._obsValues) {
            mean += v;
        }
        return mean /= (double)n;
    }

    public float getMeanError() {
        int n = this.getDataNum();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += this._fcstValues[i] - this._obsValues[i];
        }
        return (float)sum / (float)n;
    }

    public float getBias() {
        int n = this.getDataNum();
        double sumf = 0.0;
        double sumo = 0.0;
        for (int i = 0; i < n; ++i) {
            sumf += this._fcstValues[i];
            sumo += this._obsValues[i];
        }
        return (float)((sumf /= (double)n) / (sumo /= (double)n));
    }

    public float getMAE() {
        int n = this.getDataNum();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += Math.abs(this._fcstValues[i] - this._obsValues[i]);
        }
        return (float)sum / (float)n;
    }

    public float getRMSE() {
        int n = this.getDataNum();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += Math.pow(this._fcstValues[i] - this._obsValues[i], 2.0);
        }
        return (float)Math.sqrt(sum /= (double)n);
    }

    public float getMSE() {
        int n = this.getDataNum();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += Math.pow(this._fcstValues[i] - this._obsValues[i], 2.0);
        }
        return (float)(sum /= (double)n);
    }

    public float getR_bak() {
        int n = this.getDataNum();
        double meanFsct = this.getFcstMean();
        double meanObs = this.getObsMean();
        double sum = 0.0;
        double sumf = 0.0;
        double sumo = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (this._fcstValues[i] - meanFsct) * (this._obsValues[i] - meanObs);
            sumf += Math.pow(this._fcstValues[i] - meanFsct, 2.0);
            sumo += Math.pow(this._obsValues[i] - meanObs, 2.0);
        }
        sumf = Math.sqrt(sumf);
        sumo = Math.sqrt(sumo);
        return (float)(sum / (sumf * sumo));
    }

    public float getR() {
        int n = this.getDataNum();
        double x_sum = this.getObsSum();
        double y_sum = this.getFsctSum();
        double sx_sum = 0.0;
        double sy_sum = 0.0;
        double xy_sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sx_sum += this._obsValues[i] * this._obsValues[i];
            sy_sum += this._fcstValues[i] * this._fcstValues[i];
            xy_sum += this._obsValues[i] * this._fcstValues[i];
        }
        double r = ((double)n * xy_sum - x_sum * y_sum) / (Math.sqrt((double)n * sx_sum - x_sum * x_sum) * Math.sqrt((double)n * sy_sum - y_sum * y_sum));
        return (float)r;
    }

    @Override
    public Map getVerifyResult() {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("MeanErr", Float.valueOf(this.getMeanError()));
        map.put("Bias", Float.valueOf(this.getBias()));
        map.put("MAE", Float.valueOf(this.getMAE()));
        map.put("MSE", Float.valueOf(this.getMSE()));
        map.put("RMSE", Float.valueOf(this.getRMSE()));
        map.put("R", Float.valueOf(this.getR()));
        return map;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.CONTINUOUS;
    }

    @Override
    public String getScoreNames() {
        return "MeanErr,Bias,MAE,MSE,RMSE,R";
    }
}

