/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class Deflate
extends Filter {
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final String name = "zlib";
    private static final int id = 1;
    private final int clevel;

    public Deflate(Map<String, Object> properties) {
        Object levelObj = properties.get("level");
        this.clevel = levelObj == null ? 1 : (levelObj instanceof String ? Integer.parseInt((String)levelObj) : ((Number)levelObj).intValue());
        this.validateLevel();
    }

    private void validateLevel() {
        if (this.clevel < 0 || this.clevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + this.clevel);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public byte[] encode(byte[] dataIn) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(dataIn.length);
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)os, new Deflater(this.clevel));){
            dos.write(dataIn);
            dos.finish();
            dos.close();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] decode(byte[] dataIn) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Provider
    implements FilterProvider {
        @Override
        public String getName() {
            return Deflate.name;
        }

        @Override
        public int getId() {
            return 1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Deflate(properties);
        }
    }
}

