/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import javax.annotation.concurrent.Immutable;
import org.joda.time.Period;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class CalendarDuration {
    private final CalendarPeriod.Field timeUnit;
    private final double value;

    static Period convertToPeriod(int value, String udunit) {
        if (udunit.endsWith("s")) {
            udunit = udunit.substring(0, udunit.length() - 1);
        }
        switch (udunit) {
            case "msec": {
                return Period.millis((int)value);
            }
            case "sec": {
                return Period.seconds((int)value);
            }
            case "minute": {
                return Period.minutes((int)value);
            }
            case "hour": 
            case "hr": {
                return Period.hours((int)value);
            }
            case "day": {
                return Period.days((int)value);
            }
            case "week": {
                return Period.weeks((int)value);
            }
            case "month": {
                return Period.months((int)value);
            }
            case "year": {
                return Period.years((int)value);
            }
        }
        throw new IllegalArgumentException("cant convert " + udunit + " to Joda Period");
    }

    public CalendarDuration(int value, CalendarPeriod.Field timeUnit) {
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public CalendarPeriod.Field getTimeUnit() {
        return this.timeUnit;
    }

    public static CalendarDuration fromUnitString(String unitString) {
        return new CalendarDuration(1, CalendarPeriod.fromUnitString(unitString));
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.timeUnit.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarDuration that = (CalendarDuration)o;
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        return this.timeUnit == that.timeUnit;
    }

    public int hashCode() {
        int result = this.timeUnit != null ? this.timeUnit.hashCode() : 0;
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

