print 'Open data files...'
f_uwnd = addfile('D:/Temp/nc/uwnd.2011.nc')
f_vwnd = addfile('D:/Temp/nc/vwnd.2011.nc')

print 'Read data array...'
tidx = 173    # Jun 23, 2011
t = f_uwnd.gettime(tidx)
lidx = 1    # 1000 hPa
uwnd = f_uwnd['uwnd'][tidx,lidx,::-1,:]
vwnd = f_vwnd['vwnd'][tidx,lidx,::-1,:]
uwnd = uwnd[::4,::4]
vwnd = vwnd[::4,::4]

# Calculate
print 'Calculate...'
wspeed = magnitude(uwnd, vwnd)

#Plot
print 'Plot...'
axesm()
geoshow('country', edgecolor='black')
layer = contourf(wspeed, 10, cmap='grads_rainbow')
lwind = quiver(uwnd, vwnd, size=8)
title('Wind speed (' + t.strftime('%Y-%m-%d') + ')')
colorbar(layer)