# Simple data to display in various forms
x = linspace(0, 2 * pi, 400)
y = sin(x ** 2)

# Three subplots have 0 height space
f, (ax1, ax2, ax3) = subplots(3, sharex=True, hspace=0.05)
plot(x, y)
title('Set height blank space as 0')
xaxis(tickvisible=False)
ylim(-1.2, 1.2)
caxes(ax2)
scatter(x, y, edge=False)
xaxis(tickvisible=False)
ylim(-1.2, 1.2)
caxes(ax3)
scatter(x, 2 * y ** 2 - 1, color='r', edge=False)
xaxis(tickvisible=False, location='top')
ylim(-1.2, 1.2)