fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'temp.csv')
df = DataFrame.read_table(fn, delimiter=',', format='%s%f')
xt = df['temp'].values

n = len(xt)
m = n/2
ind = arange(m+1)
ak = zeros(m+1)
bk = zeros(m+1)
sksq = zeros(m+1)
ak[0] = sum(xt)/n
for k in arange(1,m+1):
    for t in arange(0,n):    
        ak[k] = ak[k] + xt[t]*cos((2*pi*k*t)/n)
        bk[k] = bk[k] + xt[t]*sin((2*pi*k*t)/n)
    ak[k] = ak[k]*2/n
    bk[k] = bk[k]*2/n
    sksq[k] = (ak[k]*ak[k]+bk[k]*bk[k])/2

width = 0.1
ax1=axes() 
y = arange(0,2.0,0.5)
x1 = arange(1,12,2.0)
x2 = 20/x1
ind = ind - width * 0.5
bar(ind,sksq,width,color='r', edgecolor=None)
yaxis(tickin=False)
xaxis(tickin=False)
yticks(y)
xticks(x1)
xlabel('k')
ylabel(r'$\rm(S^2)$', fontname='Arial')
xlim(0,12)

ax2 = twiny(ax1)
xaxis(location='top',tickin=False)
xlabel('T(year)',bold=False)
xlim(0,12) 
xticks(x1, ['%.1f' % xx for xx in x2])
title('xx test')