#Create normal distribution point data
x = random.randn(10000)
y = x * 3 + random.randn(10000)

#Calculate point density
x_g = linspace(x.min(), x.max(), 100)
y_g = linspace(y.min(), y.max(), 100)
z1,x1,y1,z = griddata((x,y), None, xi=(x_g, y_g), method='inside_count')
z = z.astype('float')
z_min = z.min()
z_max = z.max()
z = (z - z_min) / (z_max - z_min)

#Sort the points by density, so that the densest points are plotted last
idx = argsort(z)
x = x[idx]
y = y[idx]
z = z[idx]

#Plot scatter point colored by density
levs = arange(0.02, 0.99, 0.02)
ls = scatter(x, y, s=4, c=z, edgecolor=None, levs=levs)
colorbar(ls, ticks=arange(0.,1.2,0.2), tickin=False, vmintick=True, vmaxtick=True)
title('Scatter density plot example')