/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.linear;

import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;
import org.apache.commons.math4.legacy.exception.util.ExceptionContext;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;

public class NonPositiveDefiniteMatrixException
extends NumberIsTooSmallException {
    private static final long serialVersionUID = 1641613838113738061L;
    private final int index;
    private final double threshold;

    public NonPositiveDefiniteMatrixException(double wrong, int index, double threshold) {
        super((Number)wrong, (Number)threshold, false);
        this.index = index;
        this.threshold = threshold;
        ExceptionContext context = this.getContext();
        context.addMessage((Localizable)LocalizedFormats.NOT_POSITIVE_DEFINITE_MATRIX, new Object[0]);
        context.addMessage((Localizable)LocalizedFormats.ARRAY_ELEMENT, new Object[]{wrong, index});
    }

    public int getRow() {
        return this.index;
    }

    public int getColumn() {
        return this.index;
    }

    public double getThreshold() {
        return this.threshold;
    }
}

