/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.unidata.io.RandomAccessFile;

public class Ray {
    int raySize;
    long rayOffset;
    static final int UF_MANDATORY_HEADER2_LEN = 90;
    static final int UF_FIELD_HEADER2_LEN = 50;
    boolean debug;
    long data_msecs;
    UF_mandatory_header2 uf_header2;
    UF_optional_header uf_opt_header;
    short numberOfFields;
    short numberOfRecords;
    short numberOfFieldsInRecord;
    Map<String, UF_field_header2> field_header_map;

    public Ray(ByteBuffer bos, int raySize, long rayOffset) {
        this.raySize = raySize;
        this.rayOffset = rayOffset;
        this.field_header_map = new HashMap<String, UF_field_header2>();
        bos.position(0);
        byte[] data = new byte[90];
        bos.get(data);
        this.uf_header2 = new UF_mandatory_header2(data);
        if (this.uf_header2.offset2StartOfOptionalHeader > 0 && this.uf_header2.dataHeaderPosition != this.uf_header2.offset2StartOfOptionalHeader) {
            data = new byte[28];
            bos.get(data);
            this.uf_opt_header = new UF_optional_header(data);
        }
        int position = this.uf_header2.dataHeaderPosition * 2 - 2;
        bos.position(position);
        this.data_msecs = this.setDateMesc();
        byte[] b2 = new byte[2];
        bos.get(b2);
        this.numberOfFields = this.getShort(b2, 0);
        bos.get(b2);
        this.numberOfRecords = this.getShort(b2, 0);
        bos.get(b2);
        this.numberOfFieldsInRecord = this.getShort(b2, 0);
        data = new byte[50];
        for (int i = 0; i < this.numberOfFields; ++i) {
            bos.get(b2);
            String type = new String(b2, StandardCharsets.UTF_8);
            bos.get(b2);
            short offs = this.getShort(b2, 0);
            int position0 = bos.position();
            bos.position(offs * 2 - 2);
            bos.get(data);
            UF_field_header2 field_header = new UF_field_header2(data);
            bos.position(position0);
            this.field_header_map.put(type, field_header);
        }
    }

    public int getRaySize() {
        return this.raySize;
    }

    public int getGateCount(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return header.binCount;
    }

    public String getDatatypeName(String abbrev) {
        switch (abbrev) {
            case "ZN": 
            case "ZS": 
            case "ZF": 
            case "ZX": {
                return "Reflectivity";
            }
            case "VR": 
            case "DN": 
            case "DS": 
            case "DF": 
            case "DX": {
                return "RadialVelocity";
            }
            case "VN": 
            case "VF": {
                return "CorrectedRadialVelocity";
            }
            case "SW": 
            case "WS": 
            case "WF": 
            case "WX": 
            case "WN": {
                return "SpectrumWidth";
            }
            case "PN": 
            case "PS": 
            case "PF": 
            case "PX": 
            case "MN": 
            case "MS": 
            case "MF": 
            case "MX": {
                return "Power";
            }
            case "PH": {
                return "PhiDP";
            }
            case "RH": {
                return "RhoHV";
            }
            case "LH": {
                return "LdrH";
            }
            case "KD": {
                return "KDP";
            }
            case "LV": {
                return "LdrV";
            }
            case "CZ": {
                return "CorrecteddBZ";
            }
            case "DZ": {
                return "TotalReflectivity";
            }
            case "DR": {
                return "ZDR";
            }
        }
        return abbrev;
    }

    public String getDatatypeUnits(String abbrev) {
        switch (abbrev) {
            case "CZ": 
            case "DZ": 
            case "ZN": 
            case "ZS": 
            case "ZF": 
            case "ZX": {
                return "dBz";
            }
            case "VR": 
            case "DN": 
            case "DS": 
            case "DF": 
            case "DX": 
            case "VN": 
            case "VF": 
            case "SW": 
            case "WS": 
            case "WF": 
            case "WX": 
            case "WN": {
                return "m/s";
            }
            case "PN": 
            case "PS": 
            case "PF": 
            case "PX": 
            case "MN": 
            case "MS": 
            case "MF": 
            case "MX": {
                return "dBM";
            }
        }
        return abbrev;
    }

    public short getDatatypeRangeFoldingThreshhold(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return header.thresholdValue;
    }

    public float getDatatypeScaleFactor(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return 1.0f / (float)header.scaleFactor;
    }

    public float getDatatypeAddOffset(String abbrev) {
        return 0.0f;
    }

    public int getGateStart(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return header.startRange;
    }

    public int getDataOffset(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return header.dataOffset;
    }

    public int getGateSize(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return header.binSpacing;
    }

    public float getElevation() {
        return (float)this.uf_header2.elevation / 64.0f;
    }

    public float getAzimuth() {
        return (float)this.uf_header2.azimuth / 64.0f;
    }

    public short getMissingData() {
        return this.uf_header2.missing;
    }

    public int getYear() {
        return this.getYear(this.uf_header2.year);
    }

    public float getLatitude() {
        return (float)this.uf_header2.latitudeD + ((float)this.uf_header2.latitudeM + (float)this.uf_header2.latitudeS / 3840.0f) / 60.0f;
    }

    public float getLongtitude() {
        return (float)this.uf_header2.longitudeD + ((float)this.uf_header2.longitudeM + (float)this.uf_header2.longitudeS / 3840.0f) / 60.0f;
    }

    public float getHorizontalBeamWidth(String abbrev) {
        UF_field_header2 header = this.field_header_map.get(abbrev);
        return (float)header.HorizontalBeamWidth / 64.0f;
    }

    public int getYear(int year) {
        if (year > 1970) {
            return year;
        }
        if (year > 70 && year < 100) {
            return 1900 + year;
        }
        if (year < 60) {
            return 2000 + year;
        }
        return 0;
    }

    public long getTitleMsecs() {
        return this.data_msecs;
    }

    public long setDateMesc() {
        Calendar cal = this.uf_header2.timeZone.equals("UT") || this.uf_header2.timeZone.equals("GM") ? Calendar.getInstance(TimeZone.getTimeZone("UTC")) : Calendar.getInstance();
        cal.set(1, this.uf_header2.year);
        cal.set(2, this.uf_header2.month - 1);
        cal.set(5, this.uf_header2.day);
        cal.set(11, this.uf_header2.hour);
        cal.set(12, this.uf_header2.minute);
        cal.set(13, this.uf_header2.second);
        return cal.getTimeInMillis();
    }

    public Date getDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.data_msecs);
        return cal.getTime();
    }

    protected short getShort(byte[] bytes, int offset) {
        return (short)Ray.bytesToShort(bytes[offset], bytes[offset + 1], false);
    }

    public static int bytesToShort(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public short[] byte2short(byte[] a, int length) {
        int len = length / 2;
        short[] b = new short[len];
        byte[] b2 = new byte[2];
        for (int i = 0; i < len; ++i) {
            b2[0] = a[2 * i];
            b2[1] = a[2 * i + 1];
            b[i] = this.getShort(b2, 0);
        }
        return b;
    }

    public void readData(RandomAccessFile raf, String abbrev, Range gateRange, IndexIterator ii) throws IOException {
        long offset = this.rayOffset;
        raf.seek(offset += (long)(this.getDataOffset(abbrev) * 2 - 2));
        byte[] b2 = new byte[2];
        int dataCount = this.getGateCount(abbrev);
        byte[] data = new byte[dataCount * 2];
        raf.readFully(data);
        Iterator iterator = gateRange.iterator();
        while (iterator.hasNext()) {
            int gateIdx = (Integer)iterator.next();
            if (gateIdx >= dataCount) {
                ii.setShortNext(this.uf_header2.missing);
                continue;
            }
            b2[0] = data[gateIdx * 2];
            b2[1] = data[gateIdx * 2 + 1];
            short value = this.getShort(b2, 0);
            ii.setShortNext(value);
        }
    }

    class UF_field_header2 {
        short dataOffset;
        short scaleFactor;
        short startRange;
        short startRange1;
        short binSpacing;
        short binCount;
        short pulseWidth;
        short HorizontalBeamWidth;
        short verticalBeamWidth;
        short receiverBandwidth;
        short polarization;
        short waveLength;
        short sampleSize;
        String typeOfData;
        short thresholdValue;
        short scale;
        String editCode;
        short prt;
        short bits;

        UF_field_header2(byte[] data) {
            this.dataOffset = Ray.this.getShort(data, 0);
            this.scaleFactor = Ray.this.getShort(data, 2);
            this.startRange = Ray.this.getShort(data, 4);
            this.startRange1 = Ray.this.getShort(data, 6);
            this.binSpacing = Ray.this.getShort(data, 8);
            this.binCount = Ray.this.getShort(data, 10);
            this.pulseWidth = Ray.this.getShort(data, 12);
            this.HorizontalBeamWidth = Ray.this.getShort(data, 14);
            this.verticalBeamWidth = Ray.this.getShort(data, 16);
            this.receiverBandwidth = Ray.this.getShort(data, 18);
            this.polarization = Ray.this.getShort(data, 20);
            this.waveLength = Ray.this.getShort(data, 22);
            this.sampleSize = Ray.this.getShort(data, 24);
            this.typeOfData = new String(data, 26, 2, StandardCharsets.UTF_8);
            this.thresholdValue = Ray.this.getShort(data, 28);
            this.scale = Ray.this.getShort(data, 30);
            this.editCode = new String(data, 32, 2, StandardCharsets.UTF_8);
            this.prt = Ray.this.getShort(data, 34);
            this.bits = Ray.this.getShort(data, 36);
        }
    }

    class UF_optional_header {
        String sProjectName;
        short iBaselineAzimuth;
        short iBaselineelevation;
        short iVolumeScanHour;
        short iVolumeScanMinute;
        short iVolumeScanSecond;
        String sFieldTapeName;
        short iFlag;

        UF_optional_header(byte[] data) {
            this.sProjectName = new String(data, 0, 8, StandardCharsets.UTF_8);
            this.iBaselineAzimuth = Ray.this.getShort(data, 8);
            this.iBaselineelevation = Ray.this.getShort(data, 10);
            this.iVolumeScanHour = Ray.this.getShort(data, 12);
            this.iVolumeScanMinute = Ray.this.getShort(data, 14);
            this.iVolumeScanSecond = Ray.this.getShort(data, 16);
            this.sFieldTapeName = new String(data, 18, 8, StandardCharsets.UTF_8);
            this.iFlag = Ray.this.getShort(data, 26);
        }
    }

    class UF_mandatory_header2 {
        String textUF;
        short recordSize;
        short offset2StartOfOptionalHeader;
        short localUseHeaderPosition;
        short dataHeaderPosition;
        short recordNumber;
        short volumeNumber;
        short rayNumber;
        short recordNumber1;
        short sweepNumber;
        String radarName;
        String siteName;
        short latitudeD;
        short latitudeM;
        short latitudeS;
        short longitudeD;
        short longitudeM;
        short longitudeS;
        short height;
        short year;
        short month;
        short day;
        short hour;
        short minute;
        short second;
        String timeZone;
        short azimuth;
        short elevation;
        short sweepMode;
        short fixedAngle;
        short sweepRate;
        short year1;
        short month1;
        short day1;
        String nameOfUFGeneratorProgram;
        short missing;

        UF_mandatory_header2(byte[] data) {
            this.textUF = new String(data, 0, 2, StandardCharsets.UTF_8);
            if (Ray.this.debug) {
                System.out.println(this.textUF);
            }
            this.recordSize = Ray.this.getShort(data, 2);
            this.offset2StartOfOptionalHeader = Ray.this.getShort(data, 4);
            this.localUseHeaderPosition = Ray.this.getShort(data, 6);
            this.dataHeaderPosition = Ray.this.getShort(data, 8);
            this.recordNumber = Ray.this.getShort(data, 10);
            this.volumeNumber = Ray.this.getShort(data, 12);
            this.rayNumber = Ray.this.getShort(data, 14);
            this.recordNumber1 = Ray.this.getShort(data, 16);
            this.sweepNumber = Ray.this.getShort(data, 18);
            this.radarName = new String(data, 20, 8, StandardCharsets.UTF_8).trim();
            this.siteName = new String(data, 28, 8, StandardCharsets.UTF_8).trim();
            this.latitudeD = Ray.this.getShort(data, 36);
            this.latitudeM = Ray.this.getShort(data, 38);
            this.latitudeS = Ray.this.getShort(data, 40);
            this.longitudeD = Ray.this.getShort(data, 42);
            this.longitudeM = Ray.this.getShort(data, 44);
            this.longitudeS = Ray.this.getShort(data, 46);
            this.height = Ray.this.getShort(data, 48);
            short yearValue = Ray.this.getShort(data, 50);
            this.year = (short)Ray.this.getYear(yearValue);
            this.month = Ray.this.getShort(data, 52);
            this.day = Ray.this.getShort(data, 54);
            this.hour = Ray.this.getShort(data, 56);
            this.minute = Ray.this.getShort(data, 58);
            this.second = Ray.this.getShort(data, 60);
            this.timeZone = new String(data, 62, 2, StandardCharsets.UTF_8);
            this.azimuth = Ray.this.getShort(data, 64);
            this.elevation = Ray.this.getShort(data, 66);
            this.sweepMode = Ray.this.getShort(data, 68);
            this.fixedAngle = Ray.this.getShort(data, 70);
            this.sweepRate = Ray.this.getShort(data, 72);
            this.year1 = Ray.this.getShort(data, 74);
            this.month1 = Ray.this.getShort(data, 76);
            this.day1 = Ray.this.getShort(data, 78);
            this.nameOfUFGeneratorProgram = new String(data, 80, 8, StandardCharsets.UTF_8);
            this.missing = Ray.this.getShort(data, 88);
        }
    }
}

