/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy.dict;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.meteoinfo.ndarray.io.npy.dict.PyNone;
import org.meteoinfo.ndarray.io.npy.dict.PyValue;

final class PyDict
implements PyValue {
    private final List<Entry> entries = new ArrayList<Entry>();

    PyDict() {
    }

    @Override
    public boolean isDict() {
        return true;
    }

    void put(String key, PyValue value) {
        if (key == null || value == null) {
            return;
        }
        this.entries.add(new Entry(key, value));
    }

    PyValue get(String key) {
        for (Entry entry : this.entries) {
            if (!Objects.equals(key, entry.key())) continue;
            return entry.value;
        }
        return PyNone.get();
    }

    public int size() {
        return this.entries.size();
    }

    void forEach(BiConsumer<String, PyValue> fn) {
        for (Entry entry : this.entries) {
            fn.accept(entry.key(), entry.value());
        }
    }

    static class Entry {
        private final String key;
        private final PyValue value;

        Entry(String key, PyValue value) {
            this.key = key;
            this.value = value;
        }

        String key() {
            return this.key;
        }

        PyValue value() {
            return this.value;
        }
    }
}

