/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class SmallMeanPoissonSampler
implements SharedStateDiscreteSampler {
    private final double p0;
    private final int limit;
    private final UniformRandomProvider rng;

    public SmallMeanPoissonSampler(UniformRandomProvider rng, double mean) {
        this.rng = rng;
        if (mean <= 0.0) {
            throw new IllegalArgumentException("mean is not strictly positive: " + mean);
        }
        this.p0 = Math.exp(-mean);
        if (!(this.p0 > 0.0)) {
            throw new IllegalArgumentException("No p(x=0) probability for mean: " + mean);
        }
        this.limit = (int)Math.ceil(1000.0 * mean);
    }

    private SmallMeanPoissonSampler(UniformRandomProvider rng, SmallMeanPoissonSampler source) {
        this.rng = rng;
        this.p0 = source.p0;
        this.limit = source.limit;
    }

    @Override
    public int sample() {
        int n;
        double r = 1.0;
        for (n = 0; n < this.limit && (r *= this.rng.nextDouble()) >= this.p0; ++n) {
        }
        return n;
    }

    public String toString() {
        return "Small Mean Poisson deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new SmallMeanPoissonSampler(rng, this);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double mean) {
        return new SmallMeanPoissonSampler(rng, mean);
    }
}

