/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.Variable;

public class FrmUVSet
extends JDialog {
    private boolean _isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JComboBox jComboBox_UData;
    private JComboBox jComboBox_UDir;
    private JComboBox jComboBox_VData;
    private JComboBox jComboBox_VSpeed;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButton_DirSpeed;
    private JRadioButton jRadioButton_UV;
    private JSpinner jSpinner_XSkip;
    private JSpinner jSpinner_YSkip;

    public FrmUVSet(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButton_UV = new JRadioButton();
        this.jRadioButton_DirSpeed = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinner_XSkip = new JSpinner();
        this.jSpinner_YSkip = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBox_UDir = new JComboBox();
        this.jComboBox_VSpeed = new JComboBox();
        this.jComboBox_UData = new JComboBox();
        this.jComboBox_VData = new JComboBox();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButton_UV);
        this.jRadioButton_UV.setText("U/V");
        this.jRadioButton_UV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUVSet.this.jRadioButton_UVActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton_DirSpeed);
        this.jRadioButton_DirSpeed.setText("Direction/Speed");
        this.jRadioButton_DirSpeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUVSet.this.jRadioButton_DirSpeedActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButton_UV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jRadioButton_DirSpeed).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton_UV).addComponent(this.jRadioButton_DirSpeed)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Skip Factors"));
        this.jSpinner_XSkip.setModel(new SpinnerNumberModel((Number)1, null, null, (Number)1));
        this.jSpinner_YSkip.setModel(new SpinnerNumberModel((Number)1, null, null, (Number)1));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_XSkip, -2, 68, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner_YSkip))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinner_XSkip, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinner_YSkip, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel3.setText("U/Direction:");
        this.jLabel4.setText("V/Speed:");
        this.jComboBox_UDir.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_UDir.setPreferredSize(new Dimension(142, 24));
        this.jComboBox_VSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_VSpeed.setPreferredSize(new Dimension(142, 24));
        this.jComboBox_UData.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_UData.setPreferredSize(new Dimension(142, 24));
        this.jComboBox_UData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUVSet.this.jComboBox_UDataActionPerformed(evt);
            }
        });
        this.jComboBox_VData.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_VData.setPreferredSize(new Dimension(142, 24));
        this.jComboBox_VData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUVSet.this.jComboBox_VDataActionPerformed(evt);
            }
        });
        this.jButton_OK.setText("OK");
        this.jButton_OK.setPreferredSize(new Dimension(69, 23));
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUVSet.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.setPreferredSize(new Dimension(6, 23));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUVSet.this.jButton_CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_VSpeed, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_UDir, 0, 159, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox_UData, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox_VData, 0, 235, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton_OK, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_Cancel, -1, -1, Short.MAX_VALUE)).addGap(35, 35, 35)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox_UDir, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_UData, -2, -1, -2))).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox_VSpeed, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jButton_OK, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox_VData, -2, -1, -2).addComponent(this.jButton_Cancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jRadioButton_UVActionPerformed(ActionEvent evt) {
    }

    private void jRadioButton_DirSpeedActionPerformed(ActionEvent evt) {
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this._isOK = true;
        this.dispose();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBox_UDataActionPerformed(ActionEvent evt) {
        MeteoDataInfo mdi = (MeteoDataInfo)this.jComboBox_UData.getSelectedItem();
        this.updateUData(mdi);
    }

    private void updateUData(MeteoDataInfo mdi) {
        DataInfo aDataInfo = mdi.getDataInfo();
        this.jComboBox_UDir.removeAllItems();
        for (int i = 0; i < aDataInfo.getVariables().size(); ++i) {
            Variable var = (Variable)aDataInfo.getVariables().get(i);
            if (mdi.isSWATHData()) {
                Variable lonvar = aDataInfo.getVariable("longitude");
                if (!var.dimensionContains(lonvar)) continue;
                this.jComboBox_UDir.addItem(var.getName());
                continue;
            }
            if (!var.isPlottable()) continue;
            this.jComboBox_UDir.addItem(var.getName());
        }
        this.jComboBox_UDir.setSelectedItem(mdi.getVariableName());
    }

    private void jComboBox_VDataActionPerformed(ActionEvent evt) {
        MeteoDataInfo mdi = (MeteoDataInfo)this.jComboBox_VData.getSelectedItem();
        this.updateVData(mdi);
    }

    private void updateVData(MeteoDataInfo mdi) {
        DataInfo aDataInfo = mdi.getDataInfo();
        this.jComboBox_VSpeed.removeAllItems();
        for (int i = 0; i < aDataInfo.getVariables().size(); ++i) {
            Variable var = (Variable)aDataInfo.getVariables().get(i);
            if (mdi.isSWATHData()) {
                Variable lonvar = aDataInfo.getVariable("longitude");
                if (!var.dimensionContains(lonvar)) continue;
                this.jComboBox_VSpeed.addItem(var.getName());
                continue;
            }
            if (!var.isPlottable()) continue;
            this.jComboBox_VSpeed.addItem(var.getName());
        }
        this.jComboBox_VSpeed.setSelectedItem(mdi.getVariableName());
    }

    public void setUVData(List<MeteoDataInfo> dfs) {
        DefaultComboBoxModel<MeteoDataInfo> umodel = new DefaultComboBoxModel<MeteoDataInfo>();
        DefaultComboBoxModel<MeteoDataInfo> vmodel = new DefaultComboBoxModel<MeteoDataInfo>();
        for (int i = 0; i < dfs.size(); ++i) {
            umodel.addElement(dfs.get(i));
            vmodel.addElement(dfs.get(i));
        }
        this.jComboBox_UData.setModel(umodel);
        this.jComboBox_VData.setModel(vmodel);
    }

    public void setUVItems(List<String> vList) {
        this.jComboBox_UDir.removeAllItems();
        this.jComboBox_VSpeed.removeAllItems();
        for (int i = 0; i < vList.size(); ++i) {
            this.jComboBox_UDir.addItem(vList.get(i));
            this.jComboBox_VSpeed.addItem(vList.get(i));
        }
    }

    public void setUV(boolean isTrue) {
        if (isTrue) {
            this.jRadioButton_UV.setSelected(true);
        } else {
            this.jRadioButton_DirSpeed.setSelected(true);
        }
    }

    public void setUStr(String ustr) {
        this.jComboBox_UDir.setSelectedItem(ustr);
    }

    public void setVStr(String vstr) {
        this.jComboBox_VSpeed.setSelectedItem(vstr);
    }

    public void setXSkip(int xskip) {
        this.jSpinner_XSkip.setValue(xskip);
    }

    public void setYSkip(int yskip) {
        this.jSpinner_YSkip.setValue(yskip);
    }

    public MeteoDataInfo getUData() {
        return (MeteoDataInfo)this.jComboBox_UData.getSelectedItem();
    }

    public void setUData(MeteoDataInfo value) {
        this.jComboBox_UData.setSelectedItem(value);
        this.updateUData(value);
    }

    public MeteoDataInfo getVData() {
        return (MeteoDataInfo)this.jComboBox_VData.getSelectedItem();
    }

    public void setVData(MeteoDataInfo value) {
        this.jComboBox_VData.setSelectedItem(value);
        this.updateVData(value);
    }

    public String[] getUVItems() {
        String uStr = this.jComboBox_UDir.getSelectedItem().toString();
        String vStr = this.jComboBox_VSpeed.getSelectedItem().toString();
        return new String[]{uStr, vStr};
    }

    public boolean isOK() {
        return this._isOK;
    }

    public boolean isUV() {
        return this.jRadioButton_UV.isSelected();
    }

    public int getXSkip() {
        return Integer.parseInt(this.jSpinner_XSkip.getValue().toString());
    }

    public int getYSkip() {
        return Integer.parseInt(this.jSpinner_YSkip.getValue().toString());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmUVSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmUVSet dialog = new FrmUVSet((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

