/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.DimArray;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class MDFSDataInfo
extends DataInfo
implements IGridDataInfo,
IStationDataInfo {
    private int type;
    private String modelName;
    private String element;
    private String description;
    float level;
    private int numLon;
    private int numLat;
    private int numStation;
    private int numVariation;
    private int idType;
    private boolean yReverse = false;
    private Map<Integer, String> varMap;
    private Map<Integer, DataType> dataTypeMap;
    private final List<String> variableNames = new ArrayList<String>();
    private DataFrame dataFrame;

    public MDFSDataInfo() {
        this.setDataType(MeteoDataType.MICAPS_MDFS);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        try {
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            byte[] bytes = new byte[4];
            br.read(bytes);
            String desc = new String(bytes).trim();
            bytes = new byte[2];
            br.read(bytes);
            this.type = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            this.addAttribute(new Attribute("data_format", "MICAPS MDFS"));
            this.addAttribute(new Attribute("data_type", this.type));
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 12: 
                case 125: {
                    bytes = new byte[100];
                    br.read(bytes);
                    this.description = new String(bytes, "GBK").trim();
                    bytes = new byte[4];
                    br.read(bytes);
                    this.level = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    bytes = new byte[50];
                    br.read(bytes);
                    String levDesc = new String(bytes, "GBK").trim();
                    bytes = new byte[4];
                    br.read(bytes);
                    int year = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int month = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int day = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int hour = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int minute = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int second = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int timeZone = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    bytes = new byte[2];
                    br.read(bytes);
                    this.idType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.skipBytes(98);
                    bytes = new byte[4];
                    br.read(bytes);
                    this.numStation = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    bytes = new byte[2];
                    br.read(bytes);
                    this.numVariation = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    LocalDateTime dt = LocalDateTime.of(year, month, day, hour, 0);
                    this.addAttribute(new Attribute("time", dt));
                    this.addAttribute(new Attribute("level", Float.valueOf(this.level)));
                    Dimension tDim = new Dimension(DimensionType.T);
                    tDim.setName("time");
                    tDim.setValue(dt);
                    this.setTimeDimension(tDim);
                    Dimension stDim = new Dimension(DimensionType.OTHER);
                    stDim.setName("station");
                    float[] values = new float[this.numStation];
                    for (int i = 0; i < this.numStation; ++i) {
                        values[i] = i;
                    }
                    stDim.setValues(values);
                    this.addDimension(stDim);
                    this.initVarMap();
                    this.initDataTypeMap();
                    Variable var = new Variable();
                    String varName = "Stid";
                    var.setName(varName);
                    var.setStation(false);
                    var.setDataType(DataType.STRING);
                    var.setDimension(stDim);
                    var.addAttribute("name", varName);
                    this.addVariable(var);
                    this.variableNames.add(varName);
                    var = new Variable();
                    varName = "Longitude";
                    var.setName(varName);
                    var.setStation(true);
                    var.setDataType(DataType.FLOAT);
                    var.setDimension(stDim);
                    var.addAttribute("name", varName);
                    this.addVariable(var);
                    this.variableNames.add(varName);
                    var = new Variable();
                    varName = "Latitude";
                    var.setName(varName);
                    var.setStation(true);
                    var.setDataType(DataType.FLOAT);
                    var.setDimension(stDim);
                    var.addAttribute("name", varName);
                    this.variableNames.add(varName);
                    this.addVariable(var);
                    for (int i = 0; i < this.numVariation; ++i) {
                        br.read(bytes);
                        short varId = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                        br.read(bytes);
                        short dataTypeId = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                        var = new Variable();
                        varName = this.getVariableName(varId);
                        var.setName(varName);
                        var.setStation(true);
                        var.setDataType(this.dataTypeMap.get(dataTypeId));
                        var.setDimension(stDim);
                        var.addAttribute("name", varName);
                        this.addVariable(var);
                        this.variableNames.add(varName);
                    }
                    this.dataFrame = this.readDataFrame(br);
                    break;
                }
                default: {
                    int i;
                    Variable var;
                    bytes = new byte[20];
                    br.read(bytes);
                    this.modelName = new String(bytes, "GBK").trim();
                    bytes = new byte[50];
                    br.read(bytes);
                    this.element = new String(bytes, "GBK").trim();
                    bytes = new byte[30];
                    br.read(bytes);
                    this.description = new String(bytes, "GBK").trim();
                    bytes = new byte[4];
                    br.read(bytes);
                    this.level = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int year = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int month = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int day = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int hour = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int timeZone = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    int period = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float sLon = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float eLon = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float deltaLon = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    this.numLon = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float sLat = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float eLat = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float deltaLat = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    this.numLat = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float isolineStartValue = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float isolineEndValue = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.read(bytes);
                    float isolineSpace = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    br.skipBytes(2);
                    int nMembers = br.readByte();
                    nMembers = nMembers == 0 ? 1 : nMembers;
                    br.skipBytes(97);
                    LocalDateTime dt = LocalDateTime.of(year, month, day, hour, 0);
                    this.addAttribute(new Attribute("time", dt));
                    this.addAttribute(new Attribute("level", Float.valueOf(this.level)));
                    Dimension tDim = new Dimension(DimensionType.T);
                    tDim.setName("time");
                    tDim.setValue(dt);
                    this.setTimeDimension(tDim);
                    Dimension yDim = new Dimension(DimensionType.Y);
                    if (deltaLat < 0.0f) {
                        this.yReverse = true;
                        float temp = eLat;
                        eLat = sLat;
                        sLat = temp;
                        deltaLat = -deltaLat;
                    }
                    double[] Y = new double[this.numLat];
                    for (int i2 = 0; i2 < this.numLat; ++i2) {
                        Y[i2] = sLat + (float)i2 * deltaLat;
                    }
                    yDim.setValues(Y);
                    this.addDimension(yDim);
                    this.setYDimension(yDim);
                    Dimension xDim = new Dimension(DimensionType.X);
                    double[] X = new double[this.numLon];
                    for (i = 0; i < this.numLon; ++i) {
                        X[i] = sLon + (float)i * deltaLon;
                    }
                    xDim.setValues(X);
                    this.addDimension(xDim);
                    this.setXDimension(xDim);
                    switch (this.type) {
                        case 4: {
                            if (nMembers == 1) {
                                var = new Variable();
                                var.setName(this.element);
                                var.setDataType(DataType.FLOAT);
                                var.setDimension(yDim);
                                var.setDimension(xDim);
                                this.addVariable(var);
                                this.variableNames.add(this.element);
                                break;
                            }
                            for (i = 0; i < nMembers; ++i) {
                                String vName = this.element + "_" + String.valueOf(i + 1);
                                var = new Variable();
                                var.setName(vName);
                                var.setDataType(DataType.FLOAT);
                                var.setDimension(yDim);
                                var.setDimension(xDim);
                                this.addVariable(var);
                                this.variableNames.add(vName);
                            }
                            break;
                        }
                        case 11: {
                            var = new Variable();
                            var.setName("WindSpeed");
                            var.setDataType(DataType.FLOAT);
                            var.setUnits("m/s");
                            var.setDimension(yDim);
                            var.setDimension(xDim);
                            this.addVariable(var);
                            this.variableNames.add("WindSpeed");
                            var = new Variable();
                            var.setName("WindDirection");
                            var.setDataType(DataType.FLOAT);
                            var.setUnits("degree");
                            var.setDimension(yDim);
                            var.setDimension(xDim);
                            this.addVariable(var);
                            this.variableNames.add("WindDirection");
                        }
                    }
                    this.addAttribute(new Attribute("model_name", this.modelName));
                }
            }
            this.addAttribute(new Attribute("description", this.description));
            for (Dimension dim : this.dimensions) {
                Variable variable = new Variable(dim.getName());
                variable.setDimVar(true);
                variable.setCachedData(dim.getDimValue());
                variable.addDimension(dim);
                this.addCoordinate(variable);
            }
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MDFSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Object getValue(byte[] bytes, DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return bytes[0];
            }
            case SHORT: {
                return DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            }
            case INT: {
                return DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            }
            case LONG: {
                return DataConvert.bytes2Long((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            }
            case FLOAT: {
                return Float.valueOf(DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
            }
            case DOUBLE: {
                return DataConvert.bytes2Double((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            }
        }
        return new String(bytes);
    }

    private Array initDataArray(DataType dataType) {
        Array array = Array.factory((DataType)dataType, (int[])new int[]{this.numStation});
        switch (dataType) {
            case FLOAT: {
                for (int i = 0; i < this.numStation; ++i) {
                    array.setFloat(i, Float.NaN);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < this.numStation; ++i) {
                    array.setDouble(i, Double.NaN);
                }
                break;
            }
            case SHORT: {
                for (int i = 0; i < this.numStation; ++i) {
                    array.setShort(i, (short)Short.MIN_VALUE);
                }
                break;
            }
            case INT: {
                for (int i = 0; i < this.numStation; ++i) {
                    array.setInt(i, Integer.MIN_VALUE);
                }
                break;
            }
        }
        return array;
    }

    private DataFrame readDataFrame(RandomAccessFile br) throws IOException {
        ArrayList<Array> data = new ArrayList<Array>();
        ColumnIndex columns = new ColumnIndex();
        ArrayList<Integer> varSizes = new ArrayList<Integer>();
        for (Variable var : this.variables) {
            varSizes.add(this.getDataTypeSize(var.getDataType()));
            columns.add((Object)new Column(var.getName(), var.getDataType()));
            data.add(this.initDataArray(var.getDataType()));
        }
        ArrayList<String> idxList = new ArrayList<String>();
        for (int i = 0; i < this.numStation; ++i) {
            byte[] bytes;
            if (this.idType == 1) {
                bytes = new byte[2];
                br.read(bytes);
                short idLength = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                bytes = new byte[idLength];
                br.read(bytes);
                String stationId = new String(bytes);
                idxList.add(stationId);
                ((Array)data.get(0)).setString(i, stationId);
            } else {
                bytes = new byte[4];
                br.read(bytes);
                int stId = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                idxList.add(String.valueOf(stId));
                ((Array)data.get(0)).setString(i, String.valueOf(stId));
            }
            bytes = new byte[4];
            br.read(bytes);
            float lon = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            ((Array)data.get(1)).setFloat(i, lon);
            br.read(bytes);
            float lat = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            ((Array)data.get(2)).setFloat(i, lat);
            bytes = new byte[2];
            br.read(bytes);
            int numVar = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            if (numVar > this.numVariation) break;
            for (int j = 0; j < numVar; ++j) {
                bytes = new byte[2];
                br.read(bytes);
                short varId = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                String varName = this.getVariableName(varId);
                int idx = this.variableNames.indexOf(varName);
                bytes = new byte[((Integer)varSizes.get(idx)).intValue()];
                br.read(bytes);
                ((Array)data.get(idx)).setObject(i, this.getValue(bytes, ((Column)columns.get(idx)).getDataType()));
            }
        }
        Index index = Index.factory(idxList);
        DataFrame df = new DataFrame(data, index, columns);
        return df;
    }

    public DataFrame readDataFrame() {
        return this.dataFrame;
    }

    @Override
    public Array realRead(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.realRead(varName, origin, size, stride);
        return r;
    }

    private byte[] readDataBytes(String varName) {
        int length = this.numLat * this.numLon * 4;
        byte[] bytes = new byte[length];
        try {
            RandomAccessFile br = new RandomAccessFile(this.fileName, "r");
            switch (this.type) {
                case 11: {
                    br.skipBytes(278);
                    if (varName.equals("WindDirection")) {
                        br.skipBytes(length);
                    }
                    br.read(bytes);
                    break;
                }
                case 4: {
                    int idx = this.variableNames.indexOf(varName);
                    if (idx > 0) {
                        br.skipBytes(idx * (278 + length));
                    }
                    br.skipBytes(278);
                    br.read(bytes);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Section section = new Section(origin, size, stride);
            Variable variable = this.getVariable(varName);
            Array dataArray = Array.factory((DataType)variable.getDataType(), (int[])section.getShape());
            IndexIterator ii = dataArray.getIndexIterator();
            int rangeIdx = 0;
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 12: 
                case 125: {
                    Range stRange = section.getRange(rangeIdx);
                    Array array = this.dataFrame.getColumnData(varName);
                    for (int i = stRange.first(); i <= stRange.last(); i += stRange.stride()) {
                        ii.setObjectNext(array.getObject(i));
                    }
                    break;
                }
                case 4: 
                case 11: {
                    byte[] dataBytes = this.readDataBytes(varName);
                    Range yRange = section.getRange(rangeIdx++);
                    Range xRange = section.getRange(rangeIdx);
                    int xNum = this.numLon;
                    byte[] bytes = new byte[4];
                    if (this.type == 11 && varName.equals("WindDirection")) {
                        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                                int index = this.yReverse ? (this.numLat - y - 1) * xNum + x : y * xNum + x;
                                System.arraycopy(dataBytes, index * 4, bytes, 0, 4);
                                float v = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                                v = 360.0f - (v + 90.0f);
                                if (v < 0.0f) {
                                    v += 360.0f;
                                }
                                ii.setFloatNext(v);
                            }
                        }
                    } else {
                        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                                int index = this.yReverse ? (this.numLat - y - 1) * xNum + x : y * xNum + x;
                                System.arraycopy(dataBytes, index * 4, bytes, 0, 4);
                                float v = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                                ii.setFloatNext(v);
                            }
                        }
                    }
                    break;
                }
            }
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(MDFSDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public DimArray readDimArray(String varName) {
        return null;
    }

    @Override
    public DimArray readDimArray(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return null;
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        byte[] dataBytes = this.readDataBytes(varName);
        double[][] data = new double[this.numLat][this.numLon];
        byte[] bytes = new byte[4];
        if (this.type == 11 && varName.equals("WindDirection")) {
            for (int i = 0; i < this.numLat; ++i) {
                for (int j = 0; j < this.numLon; ++j) {
                    int index = this.yReverse ? (this.numLat - i - 1) * this.numLon + j : i * this.numLon + j;
                    System.arraycopy(dataBytes, index * 4, bytes, 0, 4);
                    float wd = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                    wd = 360.0f - (wd + 90.0f);
                    if (wd < 0.0f) {
                        wd += 360.0f;
                    }
                    data[i][j] = wd;
                }
            }
        } else {
            for (int i = 0; i < this.numLat; ++i) {
                for (int j = 0; j < this.numLon; ++j) {
                    int index = this.yReverse ? (this.numLat - i - 1) * this.numLon + j : i * this.numLon + j;
                    System.arraycopy(dataBytes, index * 4, bytes, 0, 4);
                    data[i][j] = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
        return new GridData(data, this.getXDimension().getValues(), this.getYDimension().getValues(), this.missingValue);
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        return null;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        double[][] data = new double[this.numStation][3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        ArrayList<String> stations = new ArrayList<String>();
        try {
            Array array = this.dataFrame.getColumnData(varName);
            Array stArray = this.dataFrame.getColumnData("Stid");
            Array lonArray = this.dataFrame.getColumnData("Longitude");
            Array latArray = this.dataFrame.getColumnData("Latitude");
            for (int i = 0; i < this.numStation; ++i) {
                stations.add(stArray.getString(i));
                double lon = lonArray.getDouble(i);
                double lat = latArray.getDouble(i);
                double v = array.getDouble(i);
                data[i][0] = lon;
                data[i][1] = lat;
                data[i][2] = v;
                if (i == 0) {
                    maxX = minX = lon;
                    maxY = minY = lat;
                    continue;
                }
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                    continue;
                }
                if (!(maxY < lat)) continue;
                maxY = lat;
            }
            Extent dataExtent = new Extent();
            dataExtent.minX = minX;
            dataExtent.maxX = maxX;
            dataExtent.minY = minY;
            dataExtent.maxY = maxY;
            StationData stData = new StationData();
            stData.data = data;
            stData.stations = stations;
            stData.dataExtent = dataExtent;
            stData.missingValue = this.getMissingValue();
            return stData;
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        StationInfoData stInfoData = new StationInfoData();
        stInfoData.setDataFrame(this.dataFrame);
        stInfoData.setStations(this.dataFrame.getIndex().getValues());
        return stInfoData;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        return null;
    }

    private String getVariableName(int varId) {
        if (this.varMap.containsKey(varId)) {
            return this.varMap.get(varId);
        }
        if (varId % 2 == 0 && varId > 200) {
            if (this.varMap.containsKey(--varId)) {
                return "Q_" + this.varMap.get(varId);
            }
            return "Undefined_" + String.valueOf(varId);
        }
        return "Undefined_" + String.valueOf(varId);
    }

    private int getDataTypeSize(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return 1;
            }
        }
        return dataType.getSize();
    }

    private void initDataTypeMap() {
        this.dataTypeMap = new HashMap<Integer, DataType>();
        this.dataTypeMap.put(1, DataType.BYTE);
        this.dataTypeMap.put(2, DataType.SHORT);
        this.dataTypeMap.put(3, DataType.INT);
        this.dataTypeMap.put(4, DataType.LONG);
        this.dataTypeMap.put(5, DataType.FLOAT);
        this.dataTypeMap.put(6, DataType.DOUBLE);
        this.dataTypeMap.put(7, DataType.STRING);
    }

    private void initVarMap() {
        this.varMap = new HashMap<Integer, String>();
        this.varMap.put(1, "Longitude");
        this.varMap.put(2, "Latitude");
        this.varMap.put(3, "Altitude");
        this.varMap.put(4, "Grade");
        this.varMap.put(5, "StationType");
        this.varMap.put(6, "PressHeight");
        this.varMap.put(7, "HumidityHeight");
        this.varMap.put(8, "HumidityHeightWater");
        this.varMap.put(9, "WindHeight");
        this.varMap.put(10, "WindHeightPlat");
        this.varMap.put(11, "WindHeightWater");
        this.varMap.put(12, "MoveDirection");
        this.varMap.put(13, "MoveSpeed");
        this.varMap.put(14, "SeaSaltDepth");
        this.varMap.put(15, "WaveHeightAlt");
        this.varMap.put(16, "BuoyPos");
        this.varMap.put(17, "WaterDepth");
        this.varMap.put(18, "UnderWaterDepth");
        this.varMap.put(19, "BoatSeaHeight");
        this.varMap.put(20, "Azimuth");
        this.varMap.put(21, "StationName");
        this.varMap.put(201, "WindDirection");
        this.varMap.put(203, "WindSpeed");
        this.varMap.put(205, "WD_1Min");
        this.varMap.put(207, "WS_1Min");
        this.varMap.put(209, "WD_2Min");
        this.varMap.put(211, "WS_2Min");
        this.varMap.put(213, "WD_10Min");
        this.varMap.put(215, "WS_10Min");
        this.varMap.put(217, "WD_Max");
        this.varMap.put(219, "WS_Max");
        this.varMap.put(221, "WD_Inst");
        this.varMap.put(223, "WS_Inst");
        this.varMap.put(225, "WD_Extra");
        this.varMap.put(227, "WS_Extra");
        this.varMap.put(229, "WD_6H");
        this.varMap.put(231, "WS_6H");
        this.varMap.put(233, "WD_12H");
        this.varMap.put(235, "WS_12H");
        this.varMap.put(237, "WindForce");
        this.varMap.put(401, "Pressure_SeaLevel");
        this.varMap.put(403, "Pressure_Var_3H");
        this.varMap.put(405, "Pressure_Var_24H");
        this.varMap.put(407, "Pressure_Station");
        this.varMap.put(409, "Pressure_Max");
        this.varMap.put(411, "Pressure_Min");
        this.varMap.put(413, "Pressure");
        this.varMap.put(415, "Pressure_DayAve");
        this.varMap.put(417, "Pressure_SeaLevel_DayAve");
        this.varMap.put(419, "Height");
        this.varMap.put(421, "HGT");
        this.varMap.put(601, "Temperature");
        this.varMap.put(603, "Temperature_Max");
        this.varMap.put(605, "Temperature_Min");
        this.varMap.put(607, "Temperature_Var_24H");
        this.varMap.put(609, "Temperature_Max_24H");
        this.varMap.put(611, "Temperature_Min_24H");
        this.varMap.put(613, "Temperature_DayAve");
        this.varMap.put(801, "DewPoint");
        this.varMap.put(803, "T_Td_Diff");
        this.varMap.put(805, "RH");
        this.varMap.put(807, "RH_Min");
        this.varMap.put(809, "RH_DayAve");
        this.varMap.put(811, "Vapor_Pressure");
        this.varMap.put(813, "Vapor_Pressure_DayAve");
        this.varMap.put(1001, "Precipitation");
        this.varMap.put(1003, "Precipitation_1H");
        this.varMap.put(1005, "Precipitation_3H");
        this.varMap.put(1007, "Precipitation_6H");
        this.varMap.put(1009, "Precipitation_12H");
        this.varMap.put(1011, "Precipitation_24H");
        this.varMap.put(1013, "Precipitation_DaySum");
        this.varMap.put(1015, "Precipitation_20-08");
        this.varMap.put(1017, "Precipitation_08-20");
        this.varMap.put(1019, "Precipitation_20-20");
        this.varMap.put(1021, "Precipitation_08-08");
        this.varMap.put(1023, "Evaporation");
        this.varMap.put(1025, "Evaporation_Large");
        this.varMap.put(1027, "Precipitate");
        this.varMap.put(1201, "Visibility_1Min");
        this.varMap.put(1203, "Visibility_10Min");
        this.varMap.put(1205, "Visibility_Minimum");
        this.varMap.put(1207, "Visibility");
        this.varMap.put(1401, "Cloud_Total");
        this.varMap.put(1403, "Cloud_Low");
        this.varMap.put(1405, "Cloud_Base_Height");
        this.varMap.put(1407, "Cloudiness_Low");
        this.varMap.put(1409, "Cloudiness_Middle");
        this.varMap.put(1411, "Cloudiness_High");
        this.varMap.put(1413, "Cloud_Total_DayAve");
        this.varMap.put(1415, "Cloud_Low_DayAve");
        this.varMap.put(1417, "Cloud_Cover");
        this.varMap.put(1419, "Cloud_Type");
        this.varMap.put(1601, "Weather_Now");
        this.varMap.put(1603, "Weather_Past1");
        this.varMap.put(1605, "Weather_Past2");
        this.varMap.put(1801, "Tornado_Type");
        this.varMap.put(1803, "Tornado_Pos");
        this.varMap.put(1805, "Hail_Diameter_Max");
        this.varMap.put(1807, "Thunderstorm");
        this.varMap.put(1809, "Lighting_Intensity");
        this.varMap.put(2001, "Surface_Temperature");
        this.varMap.put(2003, "Surface_Temperature_Max");
        this.varMap.put(2005, "Surface_Temperature_Min");
        this.varMap.put(2007, "Surface_Temperature_Min_12H");
        this.varMap.put(2009, "Soil_Temperature_5cm");
        this.varMap.put(2011, "Soil_Temperature_10cm");
        this.varMap.put(2013, "Soil_Temperature_15cm");
        this.varMap.put(2015, "Soil_Temperature_20cm");
        this.varMap.put(2017, "Soil_Temperature_40cm");
        this.varMap.put(2019, "Soil_Temperature_80cm");
        this.varMap.put(2021, "Soil_Temperature_160cm");
        this.varMap.put(2023, "Soil_Temperature_320cm");
        this.varMap.put(2025, "Grass_Temperature");
        this.varMap.put(2027, "Grass_Temperature_Max");
        this.varMap.put(2029, "Grass_Temperature_Min");
        this.varMap.put(2031, "Surface_Temperature_DayAve");
        this.varMap.put(2033, "Soil_Temperature_DayAve_5cm");
        this.varMap.put(2035, "Soil_Temperature_DayAve_10cm");
        this.varMap.put(2037, "Soil_Temperature_DayAve_15cm");
        this.varMap.put(2039, "Soil_Temperature_DayAve_20cm");
        this.varMap.put(2041, "Soil_Temperature_DayAve_40cm");
        this.varMap.put(2043, "Soil_Temperature_DayAve_80cm");
        this.varMap.put(2045, "Soil_Temperature_DayAve_160cm");
        this.varMap.put(2047, "Soil_Temperature_DayAve_320cm");
        this.varMap.put(2049, "Grass_Temperature_DayAve");
        this.varMap.put(2201, "Surface_Condition");
        this.varMap.put(2203, "Snow_Depth");
        this.varMap.put(2205, "Snow_Pressure");
        this.varMap.put(2207, "Power_Line_Icing_Diameter");
        this.varMap.put(2209, "Power_Line_Icing_Phenomenon");
        this.varMap.put(2211, "Power_Line_Icing_Diameter_North_South");
        this.varMap.put(2213, "Power_Line_Icing_Depth_North_South");
        this.varMap.put(2215, "Power_Line_Icing_Weight_North_South");
        this.varMap.put(2217, "Power_Line_Icing_Diameter_East_West");
        this.varMap.put(2219, "Power_Line_Icing_Depth_East_West");
        this.varMap.put(2221, "Power_Line_Icing_Weight_East_West");
        this.varMap.put(2223, "Ship_Icing_Causes");
        this.varMap.put(2225, "Ship_Icing_Depth");
        this.varMap.put(2227, "Ship_Icing_Speed");
        this.varMap.put(2229, "Sea_Ice_Concentration");
        this.varMap.put(2231, "Ice_Condition_Development");
        this.varMap.put(2233, "Ice_Amount_Type");
        this.varMap.put(2235, "Ice_Edge_Orientation");
        this.varMap.put(2237, "Ice_Condition");
        this.varMap.put(2401, "Anemometer_Type");
        this.varMap.put(2403, "Wet-bulb_Temperature_Measurement_Method");
        this.varMap.put(2405, "Sea_Surface_Temperature_Measurement_Method");
        this.varMap.put(2407, "Ocean_Current_Measurement_Method");
        this.varMap.put(2409, "Barometric_Tendency_Characteristics");
        this.varMap.put(2601, "Sea_Surface_Temperature");
        this.varMap.put(2603, "Wet-bulb_Temperature");
        this.varMap.put(2605, "Sea_Surface_Salinity");
        this.varMap.put(2607, "Sea_Surface_Temperature_Max");
        this.varMap.put(2609, "Sea_Surface_Temperature_Min");
        this.varMap.put(2611, "Sea_Water_Temperature");
        this.varMap.put(2613, "Sea_Water_Salinity");
        this.varMap.put(2801, "Sea_Surface_Current_Direction");
        this.varMap.put(2803, "Sea_Surface_Current_Speed");
        this.varMap.put(2805, "Ocean_Current_Direction_Speed_Ave_Period");
        this.varMap.put(2807, "Surface_Ocean_Current_Speed");
        this.varMap.put(2809, "Surface_Ocean_Wave_Direction");
        this.varMap.put(2811, "Ocean_Current_Direction");
        this.varMap.put(2813, "Ocean_Current_Speed");
        this.varMap.put(3001, "Wave_Direction");
        this.varMap.put(3003, "Wave_Period");
        this.varMap.put(3005, "Wave_Height");
        this.varMap.put(3007, "Wind_Wave_Direction");
        this.varMap.put(3009, "Wind_Wave_Period");
        this.varMap.put(3011, "Wind_Wave_Height");
        this.varMap.put(3013, "Primary_Swell_Direction");
        this.varMap.put(3015, "Primary_Swell_Period");
        this.varMap.put(3017, "Primary_Swell_Height");
        this.varMap.put(3019, "Secondary_Swell_Direction");
        this.varMap.put(3021, "Secondary_Swell_Period");
        this.varMap.put(3023, "Secondary_Swell_Height");
        this.varMap.put(3025, "Significant_Wave_Height");
        this.varMap.put(3027, "Significant_Wave_Period");
        this.varMap.put(3029, "Average_Wave_Height");
        this.varMap.put(3031, "Average_Wave_Period");
        this.varMap.put(3033, "Maximum_Wave_Height");
        this.varMap.put(3035, "Maximum_Wave_Period");
        this.varMap.put(3037, "Manual_Wave_Height");
        this.varMap.put(3039, "Instrument_Wave_Height");
        this.varMap.put(3041, "Wave_Scale_Code");
    }
}

