/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.io;

import java.awt.Color;
import java.util.HashMap;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.io.geojson.Feature;
import org.meteoinfo.geometry.io.geojson.FeatureCollection;
import org.meteoinfo.geometry.io.geojson.GeoJSONUtil;
import org.meteoinfo.geometry.io.geojson.Geometry;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.Shape;

public class GeoJSONWriter {
    public static FeatureCollection write(VectorLayer layer) {
        Feature[] features = new Feature[layer.getShapeNum()];
        LegendScheme ls = layer.getLegendScheme();
        for (int i = 0; i < layer.getShapeNum(); ++i) {
            Shape shape = layer.getShape(i);
            Geometry geometry = GeoJSONUtil.fromShape((Shape)shape);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ColorBreak cb = ls.getLegendBreak(shape.getLegendIndex());
            switch (cb.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak pointBreak = (PointBreak)cb;
                    properties.put("marker-size", "medium");
                    properties.put("marker-color", ColorUtil.toHex((Color)pointBreak.getColor()));
                    break;
                }
                case POLYLINE_BREAK: {
                    PolylineBreak polylineBreak = (PolylineBreak)cb;
                    properties.put("stroke", ColorUtil.toHex((Color)polylineBreak.getColor()));
                    properties.put("stroke-opacity", Float.valueOf((float)polylineBreak.getColor().getAlpha() / 255.0f));
                    properties.put("stroke-width", Float.valueOf(polylineBreak.getWidth()));
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak polygonBreak = (PolygonBreak)cb;
                    properties.put("fill", ColorUtil.toHex((Color)cb.getColor()));
                    properties.put("fill-opacity", Float.valueOf((float)cb.getColor().getAlpha() / 255.0f));
                    if (polygonBreak.isDrawOutline()) {
                        properties.put("stroke", ColorUtil.toHex((Color)polygonBreak.getOutlineColor()));
                        properties.put("stroke-opacity", Float.valueOf((float)polygonBreak.getOutlineColor().getAlpha() / 255.0f));
                        properties.put("stroke-width", Float.valueOf(polygonBreak.getOutlineSize()));
                        break;
                    }
                    properties.put("stroke-opacity", 0);
                }
            }
            properties.put("title", cb.getCaption());
            features[i] = new Feature(geometry, properties);
        }
        return new FeatureCollection(features);
    }

    public static FeatureCollection write(GraphicCollection graphics) {
        Feature[] features = new Feature[graphics.getNumGraphics()];
        for (int i = 0; i < graphics.getNumGraphics(); ++i) {
            Graphic graphic = graphics.getGraphicN(i);
            Shape shape = graphic.getShape();
            Geometry geometry = GeoJSONUtil.fromShape((Shape)shape);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ColorBreak cb = graphic.getLegend();
            switch (cb.getBreakType()) {
                case POINT_BREAK: {
                    PointBreak pointBreak = (PointBreak)cb;
                    properties.put("marker-size", "medium");
                    properties.put("marker-color", ColorUtil.toHex((Color)pointBreak.getColor()));
                    break;
                }
                case POLYLINE_BREAK: {
                    PolylineBreak polylineBreak = (PolylineBreak)cb;
                    properties.put("stroke", ColorUtil.toHex((Color)polylineBreak.getColor()));
                    properties.put("stroke-opacity", Float.valueOf((float)polylineBreak.getColor().getAlpha() / 255.0f));
                    properties.put("stroke-width", Float.valueOf(polylineBreak.getWidth()));
                    break;
                }
                case POLYGON_BREAK: {
                    PolygonBreak polygonBreak = (PolygonBreak)cb;
                    properties.put("fill", ColorUtil.toHex((Color)cb.getColor()));
                    properties.put("fill-opacity", Float.valueOf((float)cb.getColor().getAlpha() / 255.0f));
                    if (polygonBreak.isDrawOutline()) {
                        properties.put("stroke", ColorUtil.toHex((Color)polygonBreak.getOutlineColor()));
                        properties.put("stroke-opacity", Float.valueOf((float)polygonBreak.getOutlineColor().getAlpha() / 255.0f));
                        properties.put("stroke-width", Float.valueOf(polygonBreak.getOutlineSize()));
                        break;
                    }
                    properties.put("stroke-opacity", 0);
                }
            }
            properties.put("title", cb.getCaption());
            features[i] = new Feature(geometry, properties);
        }
        return new FeatureCollection(features);
    }
}

