/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.mapview;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.AbstractUndoableEdit;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.mapview.FeatureUndoableEdit;
import org.meteoinfo.geo.mapview.MapView;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.table.DataRow;

public class MapViewUndoRedo {

    class SmoothFeatureEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Shape shape;
        List<PointD> oldPoints;
        List<PointD> newPoints;

        public SmoothFeatureEdit(MapView mapView, Shape shape, List<PointD> points) {
            this.mapView = mapView;
            this.shape = shape;
            this.newPoints = points;
            this.oldPoints = shape.getPoints();
        }

        @Override
        public String getPresentationName() {
            return "Resize a Graphic";
        }

        @Override
        public void undo() {
            super.undo();
            this.shape.setPoints(this.oldPoints);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.shape.setPoints(this.newPoints);
            this.mapView.paintLayers();
        }
    }

    class SmoothGraphicEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;
        List<PointD> oldPoints;
        List<PointD> newPoints;

        public SmoothGraphicEdit(MapView mapView, Graphic graphic, List<PointD> points) {
            this.mapView = mapView;
            this.graphic = graphic;
            this.newPoints = points;
            this.oldPoints = graphic.getShape().getPoints();
        }

        @Override
        public String getPresentationName() {
            return "Resize a Graphic";
        }

        @Override
        public void undo() {
            super.undo();
            this.graphic.getShape().setPoints(this.oldPoints);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.graphic.getShape().setPoints(this.newPoints);
            this.mapView.paintLayers();
        }
    }

    class ResizeGraphicEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;
        Rectangle oldRect;
        Rectangle newRect;

        public ResizeGraphicEdit(MapView mapView, Graphic graphic, Rectangle newRect) {
            this.mapView = mapView;
            this.graphic = graphic;
            this.newRect = newRect;
            this.oldRect = mapView.getGraphicRectangle(graphic);
        }

        @Override
        public String getPresentationName() {
            return "Resize a Graphic";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.resizeShapeOnScreen(this.graphic, this.oldRect);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.resizeShapeOnScreen(this.graphic, this.newRect);
            this.mapView.paintLayers();
        }
    }

    class RemoveGraphicVerticeEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;
        int verticeIdx;
        PointD vertice;

        public RemoveGraphicVerticeEdit(MapView mapView, Graphic graphic, int vIdx) {
            this.mapView = mapView;
            this.graphic = graphic;
            this.verticeIdx = vIdx;
            this.vertice = (PointD)graphic.getShape().getPoints().get(vIdx);
        }

        @Override
        public String getPresentationName() {
            return "Remove Grahic vertice";
        }

        @Override
        public void undo() {
            super.undo();
            this.graphic.verticeAddUpdate(this.verticeIdx, this.vertice);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.graphic.verticeRemoveUpdate(this.verticeIdx);
            this.mapView.paintLayers();
        }
    }

    class AddGraphicVerticeEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;
        int verticeIdx;
        PointD vertice;

        public AddGraphicVerticeEdit(MapView mapView, Graphic graphic, int vIdx, PointD vertice) {
            this.mapView = mapView;
            this.graphic = graphic;
            this.verticeIdx = vIdx;
            this.vertice = vertice;
        }

        @Override
        public String getPresentationName() {
            return "Add Grahic vertice";
        }

        @Override
        public void undo() {
            super.undo();
            this.graphic.verticeRemoveUpdate(this.verticeIdx);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.graphic.verticeAddUpdate(this.verticeIdx, this.vertice);
            this.mapView.paintLayers();
        }
    }

    class MoveGraphicVerticeEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;
        int verticeIdx;
        double newX;
        double newY;
        double oldX;
        double oldY;

        public MoveGraphicVerticeEdit(MapView mapView, Graphic graphic, int vIdx, double newX, double newY) {
            this.mapView = mapView;
            this.graphic = graphic;
            this.verticeIdx = vIdx;
            this.newX = newX;
            this.newY = newY;
            this.oldX = ((PointD)graphic.getShape().getPoints().get((int)vIdx)).X;
            this.oldY = ((PointD)graphic.getShape().getPoints().get((int)vIdx)).Y;
        }

        @Override
        public String getPresentationName() {
            return "Move Grahic vertice";
        }

        @Override
        public void undo() {
            super.undo();
            this.graphic.verticeMoveUpdate(this.verticeIdx, this.oldX, this.oldY);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.graphic.verticeMoveUpdate(this.verticeIdx, this.newX, this.newY);
            this.mapView.paintLayers();
        }
    }

    class MoveGraphicEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;
        Point fromPoint;
        Point toPoint;

        public MoveGraphicEdit(MapView mapView, Graphic graphic, Point fromPoint, Point toPoint) {
            this.mapView = mapView;
            this.graphic = graphic;
            this.fromPoint = new Point(fromPoint.x, fromPoint.y);
            this.toPoint = new Point(toPoint.x, toPoint.y);
        }

        @Override
        public String getPresentationName() {
            return "Move a Graphic";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.moveShapeOnScreen(this.graphic.getShape(), this.toPoint, this.fromPoint);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.moveShapeOnScreen(this.graphic.getShape(), this.fromPoint, this.toPoint);
            this.mapView.paintLayers();
        }
    }

    class RemoveGraphicsEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        List<Graphic> graphics;

        public RemoveGraphicsEdit(MapView mapView, List<Graphic> graphics) {
            this.mapView = mapView;
            this.graphics = new ArrayList<Graphic>(graphics);
        }

        @Override
        public String getPresentationName() {
            return "Remove Graphics";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.getGraphicCollection().addAll(this.graphics);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.getGraphicCollection().removeAll(this.graphics);
            this.mapView.paintLayers();
        }
    }

    class RemoveGraphicEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;

        public RemoveGraphicEdit(MapView mapView, Graphic graphic) {
            this.mapView = mapView;
            this.graphic = graphic;
        }

        @Override
        public String getPresentationName() {
            return "Remove a Graphic";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.getGraphicCollection().add(this.graphic);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.removeGraphic(this.graphic);
            this.mapView.paintLayers();
        }
    }

    class AddGraphicEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Graphic graphic;

        public AddGraphicEdit(MapView mapView, Graphic graphic) {
            this.mapView = mapView;
            this.graphic = graphic;
        }

        @Override
        public String getPresentationName() {
            return "Add a Graphic";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.removeGraphic(this.graphic);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.getGraphicCollection().add(this.graphic);
            this.mapView.paintLayers();
        }
    }

    class RemoveFeatureVerticeEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Shape shape;
        int verticeIdx;
        PointD vertice;

        public RemoveFeatureVerticeEdit(MapView mapView, Shape shape, int vIdx) {
            this.mapView = mapView;
            this.shape = shape;
            this.verticeIdx = vIdx;
            this.vertice = (PointD)shape.getPoints().get(vIdx);
        }

        @Override
        public String getPresentationName() {
            return "Remove feature vertice";
        }

        @Override
        public void undo() {
            super.undo();
            this.shape.addVertice(this.verticeIdx, this.vertice);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.shape.removeVertice(this.verticeIdx);
            this.mapView.paintLayers();
        }
    }

    class AddFeatureVerticeEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Shape shape;
        int verticeIdx;
        PointD vertice;

        public AddFeatureVerticeEdit(MapView mapView, Shape shape, int vIdx, PointD vertice) {
            this.mapView = mapView;
            this.shape = shape;
            this.verticeIdx = vIdx;
            this.vertice = vertice;
        }

        @Override
        public String getPresentationName() {
            return "Add feature vertice";
        }

        @Override
        public void undo() {
            super.undo();
            this.shape.removeVertice(this.verticeIdx);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.shape.addVertice(this.verticeIdx, this.vertice);
            this.mapView.paintLayers();
        }
    }

    class MoveFeatureVerticeEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        Shape shape;
        int verticeIdx;
        double newX;
        double newY;
        double oldX;
        double oldY;

        public MoveFeatureVerticeEdit(MapView mapView, Shape shape, int vIdx, double newX, double newY) {
            this.mapView = mapView;
            this.shape = shape;
            this.verticeIdx = vIdx;
            this.newX = newX;
            this.newY = newY;
            this.oldX = ((PointD)shape.getPoints().get((int)vIdx)).X;
            this.oldY = ((PointD)shape.getPoints().get((int)vIdx)).Y;
        }

        @Override
        public String getPresentationName() {
            return "Move a Feature";
        }

        @Override
        public void undo() {
            super.undo();
            this.shape.moveVertice(this.verticeIdx, this.oldX, this.oldY);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.shape.moveVertice(this.verticeIdx, this.newX, this.newY);
            this.mapView.paintLayers();
        }
    }

    class MoveFeaturesEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        List<Shape> shapes;
        Point fromPoint;
        Point toPoint;

        public MoveFeaturesEdit(MapView mapView, List<Shape> shapes, Point fromPoint, Point toPoint) {
            this.mapView = mapView;
            this.shapes = shapes;
            this.fromPoint = new Point(fromPoint.x, fromPoint.y);
            this.toPoint = new Point(toPoint.x, toPoint.y);
        }

        @Override
        public String getPresentationName() {
            return "Move a Feature";
        }

        @Override
        public void undo() {
            super.undo();
            for (Shape shape : this.shapes) {
                this.mapView.moveShapeOnScreen(shape, this.toPoint, this.fromPoint);
            }
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            for (Shape shape : this.shapes) {
                this.mapView.moveShapeOnScreen(shape, this.fromPoint, this.toPoint);
            }
            this.mapView.paintLayers();
        }
    }

    class MoveFeatureEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        Shape shape;
        Point fromPoint;
        Point toPoint;

        public MoveFeatureEdit(MapView mapView, Shape shape, Point fromPoint, Point toPoint) {
            this.mapView = mapView;
            this.shape = shape;
            this.fromPoint = new Point(fromPoint.x, fromPoint.y);
            this.toPoint = new Point(toPoint.x, toPoint.y);
        }

        @Override
        public String getPresentationName() {
            return "Move a Feature";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.moveShapeOnScreen(this.shape, this.toPoint, this.fromPoint);
            this.mapView.paintLayers();
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.moveShapeOnScreen(this.shape, this.fromPoint, this.toPoint);
            this.mapView.paintLayers();
        }
    }

    public class RemoveFeaturesEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        List<Shape> shapes;
        VectorLayer layer;
        List<Integer> indices;
        List<DataRow> records;

        public RemoveFeaturesEdit(MapView mapView, VectorLayer layer, List<Shape> shapes) {
            this.mapView = mapView;
            this.layer = layer;
            this.shapes = shapes;
            this.indices = new ArrayList<Integer>();
            this.records = new ArrayList<DataRow>();
            for (Shape shape : shapes) {
                int idx = layer.getShapes().indexOf(shape);
                DataRow row = (DataRow)layer.getAttributeTable().getTable().getRows().get(idx);
                this.indices.add(idx);
                this.records.add(row);
            }
        }

        @Override
        public String getPresentationName() {
            return "Remove Features";
        }

        @Override
        public void undo() {
            super.undo();
            try {
                for (int i = 0; i < this.shapes.size(); ++i) {
                    this.layer.editInsertShape(this.shapes.get(i), this.indices.get(i), this.records.get(i));
                }
                this.mapView.paintLayers();
                System.out.println("Undo remove features");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            for (Shape shape : this.shapes) {
                this.layer.editRemoveShape(shape);
            }
            this.mapView.paintLayers();
            System.out.println("Undo remove features");
        }
    }

    public class RemoveRingEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        PolygonShape shape;
        List<PointD> points;
        int polyIdx;
        int holeIdx;

        public RemoveRingEdit(MapView mapView, PolygonShape shape, List<PointD> hole, int polygonIdx, int holeIdx) {
            this.mapView = mapView;
            this.shape = shape;
            this.points = hole;
            this.polyIdx = polygonIdx;
            this.holeIdx = holeIdx;
        }

        @Override
        public String getPresentationName() {
            return "Remove a hole";
        }

        @Override
        public void undo() {
            super.undo();
            try {
                this.shape.addHole(this.points, this.polyIdx);
                this.mapView.paintLayers();
                System.out.println("Redo remove a hole");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            this.shape.removeHole(this.polyIdx, this.holeIdx);
            this.mapView.paintLayers();
            System.out.println("Undo remove a hole");
        }
    }

    public class FillRingEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        VectorLayer layer;
        PolygonShape shape;
        PolygonShape hole;
        int polyIdx;
        int holeIdx;

        public FillRingEdit(MapView mapView, VectorLayer layer, PolygonShape shape, PolygonShape hole, int polygonIdx, int holeIdx) {
            this.mapView = mapView;
            this.layer = layer;
            this.shape = shape;
            this.hole = hole;
            this.polyIdx = polygonIdx;
            this.holeIdx = holeIdx;
        }

        @Override
        public String getPresentationName() {
            return "Fill a hole";
        }

        @Override
        public void undo() {
            super.undo();
            this.shape.removeHole(this.polyIdx, this.holeIdx);
            this.layer.editRemoveShape((Shape)this.hole);
            this.mapView.paintLayers();
            System.out.println("Undo Fill a hole");
        }

        @Override
        public void redo() {
            super.redo();
            try {
                this.shape.addHole(this.hole.getPoints(), this.polyIdx);
                this.layer.editAddShape((Shape)this.hole);
                this.mapView.paintLayers();
                System.out.println("Redo Fill a hole");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class AddRingEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        PolygonShape shape;
        List<PointD> points;
        int polyIdx;
        int holeIdx;

        public AddRingEdit(MapView mapView, PolygonShape shape, List<PointD> points, int polygonIdx, int holeIdx) {
            this.mapView = mapView;
            this.shape = shape;
            this.points = points;
            this.polyIdx = polygonIdx;
            this.holeIdx = holeIdx;
        }

        @Override
        public String getPresentationName() {
            return "Add a hole";
        }

        @Override
        public void undo() {
            super.undo();
            this.shape.removeHole(this.polyIdx, this.holeIdx);
            this.mapView.paintLayers();
            System.out.println("Undo add a hole");
        }

        @Override
        public void redo() {
            super.redo();
            try {
                this.shape.addHole(this.points, this.polyIdx);
                this.mapView.paintLayers();
                System.out.println("Redo add a hole");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class UnionFeaturesEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        Shape shape;
        List<Shape> shapes;
        VectorLayer layer;

        public UnionFeaturesEdit(MapView mapView, VectorLayer layer, Shape shape, List<Shape> shapes) {
            this.mapView = mapView;
            this.layer = layer;
            this.shape = shape;
            this.shapes = shapes;
        }

        @Override
        public String getPresentationName() {
            return "Union Features";
        }

        @Override
        public void undo() {
            super.undo();
            try {
                this.layer.editRemoveShape(this.shape);
                for (Shape s : this.shapes) {
                    this.layer.editAddShape(s);
                }
                this.mapView.paintLayers();
                System.out.println("Undo split feature");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                for (Shape s : this.shapes) {
                    this.layer.editRemoveShape(s);
                }
                this.layer.editAddShape(this.shape);
                this.mapView.paintLayers();
                System.out.println("Redo split feature");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class SplitFeatureEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        Shape shape;
        List<Shape> shapes;
        VectorLayer layer;

        public SplitFeatureEdit(MapView mapView, VectorLayer layer, Shape shape, List<Shape> shapes) {
            this.mapView = mapView;
            this.layer = layer;
            this.shape = shape;
            this.shapes = shapes;
        }

        @Override
        public String getPresentationName() {
            return "Split Feature";
        }

        @Override
        public void undo() {
            super.undo();
            for (Shape s : this.shapes) {
                this.layer.editRemoveShape(s);
            }
            try {
                this.layer.editAddShape(this.shape);
            }
            catch (Exception ex) {
                Logger.getLogger(MapViewUndoRedo.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mapView.paintLayers();
            System.out.println("Undo split feature");
        }

        @Override
        public void redo() {
            super.redo();
            try {
                for (Shape s : this.shapes) {
                    this.layer.editAddShape(s);
                }
                this.layer.editRemoveShape(this.shape);
                this.mapView.paintLayers();
                System.out.println("Redo split feature");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class ReplaceFeatureEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        Shape s0;
        Shape s1;
        Shape s00;
        VectorLayer layer;

        public ReplaceFeatureEdit(MapView mapView, VectorLayer layer, Shape s0, Shape s1) {
            this.mapView = mapView;
            this.layer = layer;
            this.s0 = s0;
            this.s1 = s1;
            this.s00 = (Shape)s0.clone();
        }

        @Override
        public String getPresentationName() {
            return "Replace Feature";
        }

        @Override
        public void undo() {
            super.undo();
            this.s0.cloneValue(this.s00);
            this.mapView.paintLayers();
            System.out.println("Undo replace feature");
        }

        @Override
        public void redo() {
            super.redo();
            this.s0.cloneValue(this.s1);
            this.mapView.paintLayers();
            System.out.println("Redo replace feature");
        }
    }

    public class AddFeaturesEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        List<Shape> shapes;
        VectorLayer layer;

        public AddFeaturesEdit(MapView mapView, VectorLayer layer, List<Shape> shapes) {
            this.mapView = mapView;
            this.layer = layer;
            this.shapes = shapes;
        }

        @Override
        public String getPresentationName() {
            return "Add Features";
        }

        @Override
        public void undo() {
            super.undo();
            for (Shape shape : this.shapes) {
                this.layer.editRemoveShape(shape);
            }
            this.mapView.paintLayers();
            System.out.println("Undo add features");
        }

        @Override
        public void redo() {
            super.redo();
            try {
                for (Shape shape : this.shapes) {
                    this.layer.editAddShape(shape);
                }
                this.mapView.paintLayers();
                System.out.println("Redo add features");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class AddFeatureEdit
    extends FeatureUndoableEdit {
        MapView mapView;
        Shape shape;
        VectorLayer layer;

        public AddFeatureEdit(MapView mapView, VectorLayer layer, Shape shape) {
            this.mapView = mapView;
            this.layer = layer;
            this.shape = shape;
        }

        @Override
        public String getPresentationName() {
            return "Add a Feature";
        }

        @Override
        public void undo() {
            super.undo();
            this.layer.editRemoveShape(this.shape);
            this.mapView.paintLayers();
            System.out.println("Undo add a feature");
        }

        @Override
        public void redo() {
            super.redo();
            try {
                this.layer.editAddShape(this.shape);
                this.mapView.paintLayers();
                System.out.println("Redo add a feature");
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class ZoomEdit
    extends AbstractUndoableEdit {
        MapView mapView;
        Extent newExtent;
        Extent oldExtent;

        public ZoomEdit(MapView mapView, Extent oldExtent, Extent newExtent) {
            this.mapView = mapView;
            this.newExtent = newExtent;
            this.oldExtent = oldExtent;
        }

        @Override
        public String getPresentationName() {
            return "Zoom";
        }

        @Override
        public void undo() {
            super.undo();
            this.mapView.zoomToExtent(this.oldExtent);
        }

        @Override
        public void redo() {
            super.redo();
            this.mapView.zoomToExtent(this.newExtent);
        }
    }
}

