/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.preferences.choice;

import bibliothek.extension.gui.dock.preference.preferences.choice.Choice;
import bibliothek.extension.gui.dock.preference.preferences.choice.ChoiceEntryText;
import bibliothek.extension.gui.dock.preference.preferences.choice.ChoiceExtension;
import bibliothek.extension.gui.dock.preference.preferences.choice.ChoiceListener;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.extension.ExtensionName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultChoice<V>
implements Choice {
    private List<Entry<V>> list = new ArrayList<Entry<V>>();
    private boolean nullEntryAllowed = false;
    private String defaultChoice;
    private List<ChoiceListener> listeners = new ArrayList<ChoiceListener>();
    private DockController controller;

    public DefaultChoice(DockController controller) {
        if (controller != null) {
            ExtensionName<ChoiceExtension> name = new ExtensionName<ChoiceExtension>(ChoiceExtension.CHOICE_EXTENSION, ChoiceExtension.class, "choice", this);
            List<ChoiceExtension> choices = controller.getExtensions().load(name);
            Iterator iterator = choices.iterator();
            while (iterator.hasNext()) {
                ChoiceExtension item;
                ChoiceExtension choice = item = (ChoiceExtension)iterator.next();
                int n = choice.size();
                for (int i = 0; i < n; ++i) {
                    String text = choice.getText(i);
                    boolean textIsKey = choice.isTextKey(i);
                    String id = choice.getId(i);
                    Object value = choice.getChoice(i);
                    this.add(id, text, textIsKey, value);
                }
                if (this.defaultChoice != null) continue;
                this.defaultChoice = choice.getDefaultChoice();
            }
        }
    }

    @Override
    public void addChoiceListener(ChoiceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChoiceListener(ChoiceListener listener) {
        this.listeners.remove(listener);
    }

    private ChoiceListener[] listeners() {
        return this.listeners.toArray(new ChoiceListener[this.listeners.size()]);
    }

    protected void fireInserted(int start, int end) {
        for (ChoiceListener listener : this.listeners()) {
            listener.inserted(this, start, end);
        }
    }

    protected void fireRemoved(int start, int end) {
        for (ChoiceListener listener : this.listeners()) {
            listener.removed(this, start, end);
        }
    }

    protected void fireUpdated(int start, int end) {
        for (ChoiceListener listener : this.listeners()) {
            listener.updated(this, start, end);
        }
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        for (Entry<V> entry : this.list) {
            entry.setController(controller);
        }
    }

    public void remove(int index) {
        Entry<V> entry = this.list.remove(index);
        entry.setController(null);
        this.fireRemoved(index, index);
    }

    public Entry<V> add(String id, String text, V value) {
        return this.add(id, text, false, value);
    }

    public Entry<V> addLinked(String id, String text, V value) {
        return this.add(id, text, true, value);
    }

    public Entry<V> add(String id, String text, boolean textIsKey, V value) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        int index = this.list.size();
        Entry entry = textIsKey ? new IdentifiedEntry(id, text, value) : new BaseEntry(id, text, value);
        entry.setController(this.controller);
        this.list.add(entry);
        this.fireInserted(index, index);
        return entry;
    }

    @Override
    public String getId(int index) {
        return this.list.get(index).getEntryId();
    }

    @Override
    public String getText(int index) {
        return this.list.get(index).getEntryText();
    }

    public V getValue(int index) {
        return this.list.get(index).getEntryValue();
    }

    public Entry<V> getEntry(int index) {
        return this.list.get(index);
    }

    public int indexOfIdentifier(String id) {
        if (id == null) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                if (this.list.get(i).getEntryId() != null) continue;
                return i;
            }
        } else {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                if (!id.equals(this.list.get(i).getEntryId())) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfValue(V value) {
        if (value == null) {
            return -1;
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (!this.equals(this.list.get(i).getEntryValue(), value)) continue;
            return i;
        }
        return -1;
    }

    protected boolean equals(V a, V b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public String valueToIdentifier(V value) {
        int index = this.indexOfValue(value);
        if (index < 0) {
            return null;
        }
        return this.getId(index);
    }

    public V identifierToValue(String id) {
        int index = this.indexOfIdentifier(id);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public void setNullEntryAllowed(boolean nullEntryAllowed) {
        this.nullEntryAllowed = nullEntryAllowed;
    }

    @Override
    public boolean isNullEntryAllowed() {
        return this.nullEntryAllowed;
    }

    public void setDefaultChoice(String defaultChoice) {
        this.defaultChoice = defaultChoice;
    }

    @Override
    public String getDefaultChoice() {
        if (this.defaultChoice == null) {
            if (this.isNullEntryAllowed()) {
                return null;
            }
            if (this.list.size() > 0) {
                return this.list.get(0).getEntryId();
            }
            return null;
        }
        return this.defaultChoice;
    }

    private class IdentifiedEntry
    extends ChoiceEntryText
    implements Entry<V> {
        public String id;
        public V value;

        public IdentifiedEntry(String id, String text, V value) {
            super(text, DefaultChoice.this);
            this.id = id;
            this.value = value;
        }

        @Override
        protected void changed(String oldValue, String newValue) {
            int index = DefaultChoice.this.indexOfIdentifier(this.id);
            if (index >= 0) {
                DefaultChoice.this.fireUpdated(index, index);
            }
        }

        @Override
        public String getEntryId() {
            return this.id;
        }

        @Override
        public V getEntryValue() {
            return this.value;
        }

        @Override
        public void setEntryText(String text) {
            this.setValue(text);
        }

        @Override
        public String getEntryText() {
            return (String)this.value();
        }
    }

    private class BaseEntry
    implements Entry<V> {
        private String id;
        private V value;
        private String text;

        public BaseEntry(String id, String text, V value) {
            this.id = id;
            this.text = text;
            this.value = value;
        }

        @Override
        public String getEntryId() {
            return this.id;
        }

        @Override
        public V getEntryValue() {
            return this.value;
        }

        @Override
        public String getEntryText() {
            return this.text;
        }

        @Override
        public void setEntryText(String text) {
            this.text = text;
            int index = DefaultChoice.this.indexOfIdentifier(this.id);
            if (index >= 0) {
                DefaultChoice.this.fireUpdated(index, index);
            }
        }

        @Override
        public void setController(DockController controller) {
        }
    }

    public static interface Entry<V> {
        public String getEntryId();

        public V getEntryValue();

        public String getEntryText();

        public void setEntryText(String var1);

        public void setController(DockController var1);
    }
}

