/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.security.GlassedPane;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.JComponent;

public class SecureContainer
extends OverpaintablePanel {
    private DockController controller;
    private GlassedPane pane;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            SecureContainer.this.checkRestricted();
        }
    };

    public void setController(DockController controller) {
        this.controller = controller;
        if (this.pane != null) {
            this.pane.setController(controller);
        }
        this.restricted.setProperties(controller);
        this.checkRestricted();
    }

    public DockController getController() {
        return this.controller;
    }

    private void checkRestricted() {
        if (this.restricted.getProperties() != null) {
            this.setUseGlassPane(this.restricted.getValue());
        }
    }

    protected boolean isUseGlassPane() {
        return this.pane != null;
    }

    protected void setUseGlassPane(boolean use) {
        if (use) {
            if (this.pane == null) {
                this.pane = this.createGlassPane();
                this.pane.setController(this.controller);
                this.install(this.pane);
            }
        } else if (this.pane != null) {
            this.uninstall(this.pane);
            this.pane.setController(null);
            this.pane = null;
        }
    }

    protected void install(GlassedPane pane) {
        JComponent content = this.getContentPane();
        this.setBasePane(pane);
        pane.setContentPane(content);
        this.setContentPane(content);
    }

    protected void uninstall(GlassedPane pane) {
        JComponent content = this.getContentPane();
        pane.setContentPane(null);
        this.setBasePane(content);
    }

    protected GlassedPane createGlassPane() {
        return new GlassedPane();
    }
}

