/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.SwingUtilities;

public class InternalFullscreenStrategy
implements ScreenDockFullscreenStrategy {
    private JDesktopPane desktop;
    private boolean onResize = false;
    private Dimension lastSize = null;
    private ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (InternalFullscreenStrategy.this.desktop.isVisible()) {
                if (InternalFullscreenStrategy.this.lastSize == null || ((InternalFullscreenStrategy)InternalFullscreenStrategy.this).lastSize.width == 0 || ((InternalFullscreenStrategy)InternalFullscreenStrategy.this).lastSize.height == 0) {
                    InternalFullscreenStrategy.this.lastSize = InternalFullscreenStrategy.this.desktop.getSize();
                } else {
                    InternalFullscreenStrategy.this.onResize = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                for (Map.Entry entry : InternalFullscreenStrategy.this.dockables.entrySet()) {
                                    ScreenDockStation station = (ScreenDockStation)entry.getKey();
                                    for (Dockable dockable : (Dockable[])entry.getValue()) {
                                        ScreenDockWindow window = station.getWindow(dockable);
                                        window.setWindowBounds(new Rectangle(0, 0, InternalFullscreenStrategy.this.desktop.getWidth(), InternalFullscreenStrategy.this.desktop.getHeight()));
                                    }
                                    entry.setValue(station.getFullscreenChildren());
                                }
                            }
                            finally {
                                InternalFullscreenStrategy.this.onResize = false;
                            }
                        }
                    });
                }
            }
        }
    };
    private Map<ScreenDockStation, Dockable[]> dockables = new HashMap<ScreenDockStation, Dockable[]>();
    private DockStationListener stationListener = new DockStationAdapter(){

        @Override
        public void dockableAdded(DockStation station, Dockable dockable) {
            if (!InternalFullscreenStrategy.this.onResize) {
                ScreenDockStation screen = (ScreenDockStation)station;
                if (InternalFullscreenStrategy.this.dockables.containsKey(screen)) {
                    InternalFullscreenStrategy.this.dockables.put(screen, screen.getFullscreenChildren());
                }
            }
        }

        @Override
        public void dockableRemoved(DockStation station, Dockable dockable) {
            if (!InternalFullscreenStrategy.this.onResize) {
                ScreenDockStation screen = (ScreenDockStation)station;
                if (InternalFullscreenStrategy.this.dockables.containsKey(screen)) {
                    InternalFullscreenStrategy.this.dockables.put(screen, screen.getFullscreenChildren());
                }
            }
        }
    };
    private ScreenDockStationListener screenListener = new ScreenDockStationListener(){

        @Override
        public void windowRegistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
        }

        @Override
        public void windowDeregistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
        }

        @Override
        public void fullscreenChanged(ScreenDockStation station, Dockable dockable) {
            if (!InternalFullscreenStrategy.this.onResize && InternalFullscreenStrategy.this.dockables.containsKey(station)) {
                InternalFullscreenStrategy.this.dockables.put(station, station.getFullscreenChildren());
            }
        }
    };

    public InternalFullscreenStrategy(JDesktopPane desktop) {
        if (desktop == null) {
            throw new IllegalArgumentException("desktop must not be null");
        }
        this.desktop = desktop;
    }

    @Override
    public void install(ScreenDockStation station) {
        boolean empty = this.dockables.isEmpty();
        station.addDockStationListener(this.stationListener);
        station.addScreenDockStationListener(this.screenListener);
        this.dockables.put(station, station.getFullscreenChildren());
        if (empty) {
            this.desktop.addComponentListener(this.componentListener);
        }
    }

    @Override
    public void uninstall(ScreenDockStation station) {
        station.removeDockStationListener(this.stationListener);
        station.removeScreenDockStationListener(this.screenListener);
        this.dockables.remove(station);
        if (this.dockables.isEmpty()) {
            this.desktop.removeComponentListener(this.componentListener);
        }
    }

    @Override
    public boolean isFullscreen(ScreenDockWindow window) {
        Rectangle bounds = window.getWindowBounds();
        return bounds.x <= 0 && bounds.y <= 0 && bounds.width + bounds.x >= this.desktop.getWidth() && bounds.height + bounds.y >= this.desktop.getHeight();
    }

    @Override
    public void setFullscreen(ScreenDockWindow window, boolean fullscreen) {
        if (fullscreen) {
            window.setNormalBounds(window.getWindowBounds());
            window.setWindowBounds(new Rectangle(0, 0, this.desktop.getWidth(), this.desktop.getHeight()));
        } else {
            Rectangle bounds = window.getNormalBounds();
            if (bounds != null) {
                window.setWindowBounds(bounds);
                window.setNormalBounds(null);
            }
        }
    }
}

