/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeFactoryText;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeMetaListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class DefaultThemeMeta
implements ThemeMeta {
    private ThemeFactory factory;
    private DockController controller;
    private ThemeFactoryText name;
    private ThemeFactoryText description;
    private String[] authors;
    private URI[] webpages;
    private List<ThemeMetaListener> listeners = new ArrayList<ThemeMetaListener>();

    public DefaultThemeMeta(ThemeFactory factory, DockController controller, String nameId, String descriptionId, String[] authors, URI[] webpages) {
        this.factory = factory;
        this.controller = controller;
        this.authors = authors;
        this.webpages = webpages;
        this.name = new ThemeFactoryText(nameId, factory){

            @Override
            protected void changed(String oldValue, String newValue) {
                DefaultThemeMeta.this.fireNameChanged();
            }
        };
        this.description = new ThemeFactoryText(descriptionId, factory){

            @Override
            protected void changed(String oldValue, String newValue) {
                DefaultThemeMeta.this.fireDescriptionChanged();
            }
        };
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    protected void fireNameChanged() {
        for (ThemeMetaListener listener : this.listeners.toArray(new ThemeMetaListener[this.listeners.size()])) {
            listener.nameChanged(this);
        }
    }

    protected void fireDescriptionChanged() {
        for (ThemeMetaListener listener : this.listeners.toArray(new ThemeMetaListener[this.listeners.size()])) {
            listener.descriptionChanged(this);
        }
    }

    protected void fireAuthorChanged() {
        for (ThemeMetaListener listener : this.listeners.toArray(new ThemeMetaListener[this.listeners.size()])) {
            listener.authorsChanged(this);
        }
    }

    protected void fireWebpagesChanged() {
        for (ThemeMetaListener listener : this.listeners.toArray(new ThemeMetaListener[this.listeners.size()])) {
            listener.webpagesChanged(this);
        }
    }

    @Override
    public ThemeFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(ThemeFactory factory) {
        this.factory = factory;
    }

    @Override
    public void addListener(ThemeMetaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listeners.size() == 0) {
            this.name.setController(this.controller);
            this.description.setController(this.controller);
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ThemeMetaListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.name.setController(null);
            this.description.setController(null);
        }
    }

    public void setAuthors(String[] authors) {
        this.authors = authors;
        this.fireAuthorChanged();
    }

    @Override
    public String[] getAuthors() {
        return this.authors;
    }

    @Override
    public String getDescription() {
        if (this.listeners.size() == 0) {
            this.description.update(this.controller.getTexts());
        }
        return (String)this.description.value();
    }

    @Override
    public String getName() {
        if (this.listeners.size() == 0) {
            this.name.update(this.controller.getTexts());
        }
        return (String)this.name.value();
    }

    public void setWebpages(URI[] webpages) {
        this.webpages = webpages;
        this.fireWebpagesChanged();
    }

    @Override
    public URI[] getWebpages() {
        return this.webpages;
    }
}

