/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.io.geojson;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.colors.ColorUtil;
import org.meteoinfo.geometry.io.geojson.Feature;
import org.meteoinfo.geometry.io.geojson.Geometry;
import org.meteoinfo.geometry.io.geojson.LineString;
import org.meteoinfo.geometry.io.geojson.MultiLineString;
import org.meteoinfo.geometry.io.geojson.MultiPolygon;
import org.meteoinfo.geometry.io.geojson.Point;
import org.meteoinfo.geometry.io.geojson.Polygon;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class GeoJSONUtil {
    public static Shape toShape(Geometry geometry) {
        if (geometry instanceof Point) {
            return GeoJSONUtil.toShape((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return GeoJSONUtil.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return GeoJSONUtil.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return GeoJSONUtil.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return GeoJSONUtil.toShape((MultiPolygon)geometry);
        }
        throw new UnsupportedOperationException();
    }

    public static Geometry fromShape(Shape shape) {
        if (shape instanceof PointShape) {
            return GeoJSONUtil.fromShape((PointShape)shape);
        }
        if (shape instanceof PolylineShape) {
            return GeoJSONUtil.fromShape((PolylineShape)shape);
        }
        if (shape instanceof PolygonShape) {
            return GeoJSONUtil.fromShape((PolygonShape)shape);
        }
        throw new UnsupportedOperationException();
    }

    public static Point fromShape(PointShape pointShape) {
        PointD p = pointShape.getPoint();
        return new Point(p.toArray());
    }

    public static PointShape toShape(Point point) {
        double[] coordinates = point.getCoordinates();
        if (coordinates.length == 2) {
            return new PointShape(new PointD(coordinates[0], coordinates[1]));
        }
        return new PointZShape(new PointZ(coordinates[0], coordinates[1], coordinates[2]));
    }

    public static Geometry fromShape(PolylineShape polylineShape) {
        if (polylineShape.isMultiLine()) {
            int lineNum = polylineShape.getPartNum();
            double[][][] coordinates = new double[lineNum][][];
            int cNum = polylineShape.getShapeType() == ShapeTypes.POLYLINE ? 2 : 3;
            for (int j = 0; j < lineNum; ++j) {
                Polyline polyline = polylineShape.getPolylines().get(j);
                int pNum = polyline.getPointList().size();
                double[][] matrix = new double[pNum][cNum];
                for (int i = 0; i < pNum; ++i) {
                    matrix[i] = polyline.getPointList().get(i).toArray();
                }
                coordinates[j] = matrix;
            }
            return new MultiLineString(coordinates);
        }
        int cNum = polylineShape.getShapeType() == ShapeTypes.POLYLINE ? 2 : 3;
        double[][] coordinates = new double[polylineShape.getPointNum()][cNum];
        for (int i = 0; i < polylineShape.getPointNum(); ++i) {
            coordinates[i] = polylineShape.getPoints().get(i).toArray();
        }
        return new LineString(coordinates);
    }

    public static PolylineShape toShape(LineString lineString) {
        double[][] coordinates = lineString.getCoordinates();
        int pNum = coordinates.length;
        if (coordinates[0].length == 2) {
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (int i = 0; i < pNum; ++i) {
                points.add(new PointD(coordinates[i][0], coordinates[i][1]));
            }
            return new PolylineShape(points);
        }
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (int i = 0; i < pNum; ++i) {
            points.add(new PointZ(coordinates[i][0], coordinates[i][1], coordinates[i][2]));
        }
        return new PolylineZShape((List<PointZ>)points);
    }

    public static PolylineShape toShape(MultiLineString lineString) {
        double[][][] coordinates = lineString.getCoordinates();
        int lineNum = coordinates.length;
        int cNum = coordinates[0][0].length;
        if (cNum == 2) {
            PolylineShape polylineShape = new PolylineShape();
            polylineShape.setPartNum(lineNum);
            polylineShape.parts = new int[lineNum];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (int j = 0; j < lineNum; ++j) {
                int pNum;
                polylineShape.parts[j] = pNum = coordinates[j].length;
                for (int i = 0; i < pNum; ++i) {
                    points.add(new PointD(coordinates[j][i][0], coordinates[j][i][1]));
                }
            }
            polylineShape.setPoints(points);
            return polylineShape;
        }
        PolylineZShape polylineZShape = new PolylineZShape();
        polylineZShape.setPartNum(lineNum);
        polylineZShape.parts = new int[lineNum];
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (int j = 0; j < lineNum; ++j) {
            int pNum;
            polylineZShape.parts[j] = pNum = coordinates[j].length;
            for (int i = 0; i < pNum; ++i) {
                points.add(new PointZ(coordinates[j][i][0], coordinates[j][i][1], coordinates[j][i][2]));
            }
        }
        polylineZShape.setPoints(points);
        return polylineZShape;
    }

    public static Geometry fromShape(PolygonShape polygonShape) {
        int cNum;
        int n = cNum = polygonShape.getShapeType() == ShapeTypes.POLYGON ? 2 : 3;
        if (polygonShape.isMultiPolygon()) {
            int polygonNum = polygonShape.getPolygons().size();
            double[][][][] coordinates = new double[polygonNum][][][];
            for (int k = 0; k < polygonNum; ++k) {
                org.meteoinfo.geometry.shape.Polygon sPolygon = polygonShape.getPolygon(k);
                int ringNumber = sPolygon.getRingNumber();
                double[][][] a3d = new double[ringNumber][][];
                int pNum = sPolygon.getOutLine().size();
                double[][] matrix = new double[pNum][cNum];
                for (int i = 0; i < pNum; ++i) {
                    matrix[i] = sPolygon.getOutLine().get(i).toArray();
                }
                a3d[0] = matrix;
                if (sPolygon.hasHole()) {
                    for (int j = 0; j < sPolygon.getHoleLineNumber(); ++j) {
                        pNum = sPolygon.getHoleLine(j).size();
                        matrix = new double[pNum][cNum];
                        for (int i = 0; i < sPolygon.getHoleLine(j).size(); ++i) {
                            matrix[i] = sPolygon.getHoleLine(j).get(i).toArray();
                        }
                        a3d[j + 1] = matrix;
                    }
                }
                coordinates[k] = a3d;
            }
            return new MultiPolygon(coordinates);
        }
        org.meteoinfo.geometry.shape.Polygon sPolygon = polygonShape.getPolygon(0);
        int ringNum = sPolygon.getRingNumber();
        double[][][] coordinates = new double[ringNum][][];
        int pNum = sPolygon.getOutLine().size();
        double[][] matrix = new double[pNum][cNum];
        for (int i = 0; i < pNum; ++i) {
            matrix[i] = sPolygon.getOutLine().get(i).toArray();
        }
        coordinates[0] = matrix;
        if (sPolygon.hasHole()) {
            for (int j = 0; j < sPolygon.getHoleLineNumber(); ++j) {
                pNum = sPolygon.getHoleLine(j).size();
                matrix = new double[pNum][cNum];
                for (int i = 0; i < sPolygon.getHoleLine(j).size(); ++i) {
                    matrix[i] = sPolygon.getHoleLine(j).get(i).toArray();
                }
                coordinates[j + 1] = matrix;
            }
        }
        return new Polygon(coordinates);
    }

    public static PolygonShape toShape(Polygon polygon) {
        double[][][] coordinates = polygon.getCoordinates();
        int ringNum = coordinates.length;
        int cNum = coordinates[0][0].length;
        if (cNum == 2) {
            PolygonShape polygonShape = new PolygonShape();
            polygonShape.setPartNum(ringNum);
            polygonShape.parts = new int[ringNum];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (int j = 0; j < ringNum; ++j) {
                int pNum;
                polygonShape.parts[j] = pNum = coordinates[j].length;
                for (int i = 0; i < pNum; ++i) {
                    points.add(new PointD(coordinates[j][i][0], coordinates[j][i][1]));
                }
            }
            polygonShape.setPoints(points);
            return polygonShape;
        }
        PolygonZShape polygonZShape = new PolygonZShape();
        polygonZShape.setPartNum(ringNum);
        polygonZShape.parts = new int[ringNum];
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (int j = 0; j < ringNum; ++j) {
            int pNum;
            polygonZShape.parts[j] = pNum = coordinates[j].length;
            for (int i = 0; i < pNum; ++i) {
                points.add(new PointZ(coordinates[j][i][0], coordinates[j][i][1], coordinates[j][i][2]));
            }
        }
        polygonZShape.setPoints(points);
        return polygonZShape;
    }

    public static PolygonShape toShape(MultiPolygon multiPolygon) {
        double[][][][] coordinates = multiPolygon.getCoordinates();
        int polygonNum = coordinates.length;
        int cNum = coordinates[0][0][0].length;
        if (cNum == 2) {
            ArrayList<org.meteoinfo.geometry.shape.Polygon> polygons = new ArrayList<org.meteoinfo.geometry.shape.Polygon>();
            for (int k = 0; k < polygonNum; ++k) {
                int ringNum = coordinates[k].length;
                org.meteoinfo.geometry.shape.Polygon polygon = new org.meteoinfo.geometry.shape.Polygon();
                for (int j = 0; j < ringNum; ++j) {
                    ArrayList<PointD> points = new ArrayList<PointD>();
                    int pNum = coordinates[k][j].length;
                    for (int i = 0; i < pNum; ++i) {
                        points.add(new PointD(coordinates[k][j][i][0], coordinates[k][j][i][1]));
                    }
                    if (j == 0) {
                        polygon.setOutLine(points);
                        continue;
                    }
                    polygon.addHole(points);
                }
                polygons.add(polygon);
            }
            PolygonShape polygonShape = new PolygonShape();
            polygonShape.setPolygons(polygons);
            return polygonShape;
        }
        ArrayList<org.meteoinfo.geometry.shape.Polygon> polygons = new ArrayList<org.meteoinfo.geometry.shape.Polygon>();
        for (int k = 0; k < polygonNum; ++k) {
            int ringNum = coordinates[k].length;
            org.meteoinfo.geometry.shape.Polygon polygon = new org.meteoinfo.geometry.shape.Polygon();
            for (int j = 0; j < ringNum; ++j) {
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                int pNum = coordinates[k][j].length;
                for (int i = 0; i < pNum; ++i) {
                    points.add(new PointZ(coordinates[k][j][i][0], coordinates[k][j][i][1], coordinates[k][j][i][2]));
                }
                if (j == 0) {
                    polygon.setOutLine(points);
                    continue;
                }
                polygon.addHole(points);
            }
            polygons.add(polygon);
        }
        PolygonZShape polygonZShape = new PolygonZShape();
        polygonZShape.setPolygons(polygons);
        return polygonZShape;
    }

    public static ShapeTypes getShapeType(Geometry geometry) {
        if (geometry instanceof Point) {
            return ShapeTypes.POINT;
        }
        if (geometry instanceof LineString) {
            return ShapeTypes.POLYLINE;
        }
        if (geometry instanceof MultiLineString) {
            return ShapeTypes.POLYLINE;
        }
        if (geometry instanceof Polygon) {
            return ShapeTypes.POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return ShapeTypes.POLYGON;
        }
        throw new UnsupportedOperationException();
    }

    public static ShapeTypes getShapeType(Feature feature) {
        return GeoJSONUtil.getShapeType(feature.getGeometry());
    }

    public static ColorBreak getLegendBreak(Feature feature) {
        ShapeTypes shapeType = GeoJSONUtil.getShapeType(feature);
        Map<String, Object> properties = feature.getProperties();
        switch (shapeType) {
            case POINT: {
                PointBreak pointBreak = new PointBreak();
                if (properties.containsKey("marker-color")) {
                    Color color = ColorUtil.parseToColor((String)((String)properties.get("marker-color")));
                    pointBreak.setColor(color);
                }
                return pointBreak;
            }
            case POLYLINE: {
                PolylineBreak polylineBreak = new PolylineBreak();
                if (properties.containsKey("stroke")) {
                    Color color = ColorUtil.parseToColor((String)((String)properties.get("stroke")));
                    if (properties.containsKey("stroke-opacity")) {
                        float alpha = Float.parseFloat(properties.get("stroke-opacity").toString());
                        color = ColorUtil.getColor((Color)color, (float)alpha);
                    }
                    polylineBreak.setColor(color);
                }
                if (properties.containsKey("stroke-width")) {
                    float lineWidth = Float.parseFloat(properties.get("stroke-width").toString());
                    polylineBreak.setWidth(lineWidth);
                }
                return polylineBreak;
            }
            case POLYGON: {
                float alpha;
                Color color;
                String titleValue;
                PolygonBreak cb = new PolygonBreak();
                if (properties.containsKey("title")) {
                    titleValue = (String)properties.get("title");
                    cb.setStartValue(titleValue);
                    cb.setCaption(titleValue);
                } else if (properties.containsKey("name")) {
                    titleValue = (String)properties.get("name");
                    cb.setStartValue(titleValue);
                    cb.setCaption(titleValue);
                }
                if (properties.containsKey("fill")) {
                    color = ColorUtil.parseToColor((String)((String)properties.get("fill")));
                    if (properties.containsKey("fill-opacity")) {
                        alpha = Float.parseFloat(properties.get("fill-opacity").toString());
                        color = ColorUtil.getColor((Color)color, (float)alpha);
                    }
                    cb.setColor(color);
                }
                if (properties.containsKey("stroke")) {
                    color = ColorUtil.parseToColor((String)((String)properties.get("stroke")));
                    if (properties.containsKey("stroke-opacity")) {
                        alpha = Float.parseFloat(properties.get("stroke-opacity").toString());
                        color = ColorUtil.getColor((Color)color, (float)alpha);
                    }
                    cb.setOutlineColor(color);
                }
                if (properties.containsKey("stroke-width")) {
                    float lineWidth = Float.parseFloat(properties.get("stroke-width").toString());
                    cb.setOutlineSize(lineWidth);
                }
                return cb;
            }
        }
        throw new UnsupportedOperationException();
    }
}

