/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.geometry.shape.PointZ;

public class Transform {
    protected AspectType aspectType = AspectType.AUTO;
    protected float xmin;
    protected float xmax = 1.0f;
    protected float ymin;
    protected float ymax = 1.0f;
    protected float zmin;
    protected float zmax = 1.0f;
    protected Matrix4f transformMatrix = new Matrix4f();
    protected float zScale = 1.0f;

    public Transform() {
    }

    public Transform(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.setExtent(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    public Transform(Extent3D extent3D) {
        this.setExtent(extent3D);
    }

    public void setExtent(Extent3D extent3D) {
        this.setExtent((float)extent3D.minX, (float)extent3D.maxX, (float)extent3D.minY, (float)extent3D.maxY, (float)extent3D.minZ, (float)extent3D.maxZ);
    }

    public void setExtent(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
        if (this.aspectType != AspectType.AUTO) {
            float xRange = xmax - xmin;
            float yRange = ymax - ymin;
            float maxXYRange = xRange > yRange ? xRange : yRange;
            float xRatio = xRange / maxXYRange;
            float yRatio = yRange / maxXYRange;
            if (this.aspectType == AspectType.EQUAL) {
                float zRange = zmax - zmin;
                float maxRange = zRange > maxXYRange ? zRange : maxXYRange;
                xRatio = xRange / maxRange;
                yRatio = yRange / maxRange;
                float zRatio = zRange / maxRange;
                if (zRatio != 1.0f) {
                    float zCenter = (this.zmax + this.zmin) / 2.0f;
                    this.zmin = zCenter - zRange * 0.5f / zRatio;
                    this.zmax = zCenter + zRange * 0.5f / zRatio;
                }
            }
            if (xRatio != 1.0f) {
                float xCenter = (this.xmax + this.xmin) / 2.0f;
                this.xmin = xCenter - xRange * 0.5f / xRatio;
                this.xmax = xCenter + xRange * 0.5f / xRatio;
            }
            if (yRatio != 1.0f) {
                float yCenter = (this.ymax + this.ymin) / 2.0f;
                this.ymin = yCenter - yRange * 0.5f / yRatio;
                this.ymax = yCenter + yRange * 0.5f / yRatio;
            }
        }
        if (this.zScale != 1.0f) {
            float zCenter = (this.zmax + this.zmin) / 2.0f;
            float zRange = zmax - zmin;
            this.zmin = zCenter - zRange * 0.5f / this.zScale;
            this.zmax = zCenter + zRange * 0.5f / this.zScale;
        }
        this.transformMatrix = new Matrix4f().translate((this.xmax + this.xmin) / 2.0f, (this.ymax + this.ymin) / 2.0f, -(this.zmax + this.zmin) / 2.0f).scale(2.0f / (this.xmax - this.xmin), 2.0f / (this.ymax - this.ymin), 2.0f / (this.zmax - this.zmin));
    }

    public Vector3f getCenter() {
        return new Vector3f((this.xmax + this.xmin) / 2.0f, (this.ymax + this.ymin) / 2.0f, (this.zmax + this.zmin) / 2.0f);
    }

    public Vector3f getScale() {
        return new Vector3f(2.0f / (this.xmax - this.xmin), 2.0f / (this.ymax - this.ymin), 2.0f / (this.zmax - this.zmin));
    }

    public Extent3D getExtent() {
        return new Extent3D((double)this.xmin, (double)this.xmax, (double)this.ymin, (double)this.ymax, (double)this.zmin, (double)this.zmax);
    }

    public float getXLength() {
        return this.xmax - this.xmin;
    }

    public float getYLength() {
        return this.ymax - this.ymin;
    }

    public float getZLength() {
        return this.zmax - this.zmin;
    }

    public AspectType getAspectType() {
        return this.aspectType;
    }

    public void setAspectType(AspectType value) {
        this.aspectType = value;
    }

    public float getZScale() {
        return this.zScale;
    }

    public void setZScale(float value) {
        this.zScale = value;
    }

    public Matrix4f getTransformMatrix() {
        return this.transformMatrix;
    }

    public boolean equals(Transform other) {
        if (this.aspectType != other.aspectType) {
            return false;
        }
        if (this.zScale != other.zScale) {
            return false;
        }
        if (this.xmin != other.xmin) {
            return false;
        }
        if (this.xmax != other.xmax) {
            return false;
        }
        if (this.ymin != other.ymin) {
            return false;
        }
        if (this.ymax != other.ymax) {
            return false;
        }
        if (this.zmin != other.zmin) {
            return false;
        }
        return this.zmax == other.zmax;
    }

    public float transform_x(float v) {
        return (v - this.xmin) / (this.xmax - this.xmin) * 2.0f - 1.0f;
    }

    public double transform_x(double v) {
        return (v - (double)this.xmin) / (double)(this.xmax - this.xmin) * 2.0 - 1.0;
    }

    public float transform_y(float v) {
        return (v - this.ymin) / (this.ymax - this.ymin) * 2.0f - 1.0f;
    }

    public double transform_y(double v) {
        return (v - (double)this.ymin) / (double)(this.ymax - this.ymin) * 2.0 - 1.0;
    }

    public float transform_z(float v) {
        return (v - this.zmin) / (this.zmax - this.zmin) * 2.0f - 1.0f;
    }

    public double transform_z(double v) {
        return (v - (double)this.zmin) / (double)(this.zmax - this.zmin) * 2.0 - 1.0;
    }

    public float transformXDis(float len) {
        return this.transform_x(len) - this.transform_x(0.0f);
    }

    public float transformYDis(float len) {
        return this.transform_y(len) - this.transform_y(0.0f);
    }

    public float[] transformArray(float x, float y, float z) {
        return new float[]{this.transform_x(x), this.transform_y(y), this.transform_z(z)};
    }

    public Vector3f transform(float x, float y, float z) {
        return new Vector3f(this.transform_x(x), this.transform_y(y), this.transform_z(z));
    }

    public float[] transformf(PointZ p) {
        return new float[]{this.transform_x((float)p.X), this.transform_y((float)p.Y), this.transform_z((float)p.Z)};
    }

    public double[] transform(PointZ p) {
        return new double[]{this.transform_x(p.X), this.transform_y(p.Y), this.transform_z(p.Z)};
    }

    public Vector3f transform(Vector3f p) {
        return this.transform(p.x, p.y, p.z);
    }

    public static float[] toArray(Vector3f vec) {
        return new float[]{vec.x, vec.y, vec.z};
    }

    public Object clone() {
        Transform transform = new Transform(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
        transform.aspectType = this.aspectType;
        transform.zScale = this.zScale;
        return transform;
    }
}

