/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;

public class Utils {
    public static File getFilePath(File file) throws NullPointerException {
        if (file.getPath().startsWith("resources" + File.separator) || file.getPath().startsWith(File.separator + "resources" + File.separator)) {
            File modifiedFilePath = new File(Utils.class.getClassLoader().getResource(file.getPath().substring(file.getPath().indexOf("resources" + File.separator) + 10).replace("\\", "/")).getFile());
            if (!modifiedFilePath.exists()) {
                System.out.printf("%s does not exist", modifiedFilePath);
                System.exit(1);
            }
            return Utils.getFilePath(modifiedFilePath);
        }
        return file;
    }

    public static String loadResource(String fileName) throws Exception {
        try (InputStream inputStream = Utils.class.getResourceAsStream(fileName);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(" ", -1);
                if (tokens[0].equals("#include")) {
                    String includeFilename = tokens[1];
                    int pos = fileName.lastIndexOf("/");
                    includeFilename = fileName.substring(0, pos + 1) + includeFilename;
                    if (includeFilename.equals(fileName)) {
                        throw new IOException("Do not include the calling file.");
                    }
                    sb.append(Utils.loadResource(includeFilename));
                    continue;
                }
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String loadSimpleResource(String fileName) throws Exception {
        try (InputStream in = Utils.class.getResourceAsStream(fileName);){
            String string = new Scanner(in, "UTF-8").useDelimiter("\\A").next();
            return string;
        }
    }
}

