/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.zarr;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Section;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.zarr.ZArray;
import ucar.nc2.iosp.zarr.ZarrHeader;
import ucar.nc2.iosp.zarr.ZarrLayoutBB;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.zarr.RandomAccessDirectory;

public class ZarrIosp
extends AbstractIOServiceProvider {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String fileTypeId = "Zarr";
    private static final String fileTypeDescription = "Zarr v2 formatted dataset";
    private ZarrHeader header;

    public boolean isValidFile(RandomAccessFile raf) {
        return raf.isDirectory();
    }

    public IOServiceProvider.SortGroup getSortGroup() {
        return IOServiceProvider.SortGroup.GROUP_1;
    }

    public String getFileTypeId() {
        return fileTypeId;
    }

    public String getFileTypeDescription() {
        return fileTypeDescription;
    }

    public boolean isBuilder() {
        return true;
    }

    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        super.open(raf, null, cancelTask);
        this.header = new ZarrHeader((RandomAccessDirectory)raf, rootGroup);
        this.header.read();
    }

    public void buildFinish(NetcdfFile ncfile) {
    }

    public Array readData(Variable v2, Section section) {
        ZarrHeader.VInfo vinfo = (ZarrHeader.VInfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        logger.debug("DataType is '{}'", (Object)dataType);
        Object fillValue = this.getFillValue(vinfo, dataType);
        ZarrLayoutBB layout = new ZarrLayoutBB(v2, section, this.raf);
        Object data = IospHelper.readDataFill((LayoutBB)layout, (DataType)dataType, (Object)fillValue);
        Array array = Array.factory((DataType)dataType, (int[])section.getShape(), (Object)data);
        if (vinfo.getOrder() == ZArray.Order.F) {
            int n = v2.getDimensions().size();
            int[] dims = new int[n];
            for (int i = 0; i < n; ++i) {
                dims[i] = n - i - 1;
            }
            array = array.permute(dims);
        }
        return array;
    }

    private Object getFillValue(ZarrHeader.VInfo vinfo, DataType dataType) {
        Object fillValueObj;
        Object fillValue = fillValueObj = vinfo.getFillValue();
        if (fillValueObj instanceof String) {
            String fillValueStr = (String)fillValueObj;
            logger.debug("Fill value is String with value '{}'", (Object)fillValueStr);
            if (dataType.isString()) {
                return fillValueStr;
            }
            if (fillValueStr.isEmpty()) {
                return null;
            }
            switch (dataType) {
                case FLOAT: {
                    if ("NaN".equals(fillValueStr)) {
                        fillValue = Float.valueOf(Float.NaN);
                        break;
                    }
                    if ("Infinity".equals(fillValueStr)) {
                        fillValue = Float.valueOf(Float.POSITIVE_INFINITY);
                        break;
                    }
                    if ("-Infinity".equals(fillValueStr)) {
                        fillValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                        break;
                    }
                    logger.debug("String value '{}' not handled for float fill value", (Object)fillValueStr);
                    break;
                }
                case DOUBLE: {
                    if ("NaN".equals(fillValueStr)) {
                        fillValue = Double.NaN;
                        break;
                    }
                    if ("Infinity".equals(fillValueStr)) {
                        fillValue = Double.POSITIVE_INFINITY;
                        break;
                    }
                    if ("-Infinity".equals(fillValueStr)) {
                        fillValue = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    logger.debug("String value '{}' not handled for double fill value", (Object)fillValueStr);
                    break;
                }
                default: {
                    logger.debug("String value '{}' not handled for {} fill value", (Object)fillValueStr, (Object)dataType);
                }
            }
        }
        return fillValue;
    }

    public long getLastModified() {
        if (this.raf == null) {
            try {
                this.reacquire();
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return this.raf.getLastModified();
    }
}

