/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.OffHeapArray;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NativeMemory;

final class OffHeapZ016
extends OffHeapArray {
    private final long myPointer;

    OffHeapZ016(long count) {
        super(OffHeapArray.Z016, count);
        this.myPointer = NativeMemory.allocateShortArray(this, count);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.add(index, Scalar.shortValue(addend));
    }

    @Override
    public double doubleValue(long index) {
        return NativeMemory.getShort(this.myPointer, index);
    }

    @Override
    public float floatValue(long index) {
        return NativeMemory.getShort(this.myPointer, index);
    }

    @Override
    public void reset() {
        NativeMemory.initialiseShortArray(this.myPointer, this.count());
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.set(index, Scalar.shortValue(value));
    }

    @Override
    public void set(long index, double value) {
        NativeMemory.setShort(this.myPointer, index, (short)Math.toIntExact(Math.round(value)));
    }

    @Override
    public void set(long index, float value) {
        NativeMemory.setShort(this.myPointer, index, (short)Math.round(value));
    }

    @Override
    public void set(long index, short value) {
        NativeMemory.setShort(this.myPointer, index, value);
    }

    @Override
    public short shortValue(long index) {
        return NativeMemory.getShort(this.myPointer, index);
    }
}

