/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio.simulator;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.data.domain.finance.portfolio.SimplePortfolio;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.random.process.Process1D;
import org.ojalgo.random.process.RandomProcess;
import org.ojalgo.structure.Access2D;

public class PortfolioSimulator {
    private Process1D<GeometricBrownianMotion> myProcess;

    public PortfolioSimulator(Access2D<?> correlations, List<GeometricBrownianMotion> assetProcesses) {
        if (assetProcesses == null || assetProcesses.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.myProcess = correlations != null ? Process1D.of(correlations, assetProcesses) : Process1D.of(assetProcesses);
    }

    private PortfolioSimulator() {
    }

    public RandomProcess.SimulationResults simulate(int aNumberOfRealisations, int aNumberOfSteps, double aStepSize) {
        return this.simulate(aNumberOfRealisations, aNumberOfSteps, aStepSize, null);
    }

    public RandomProcess.SimulationResults simulate(int aNumberOfRealisations, int aNumberOfSteps, double aStepSize, int rebalancingInterval) {
        return this.simulate(aNumberOfRealisations, aNumberOfSteps, aStepSize, (Integer)rebalancingInterval);
    }

    RandomProcess.SimulationResults simulate(int aNumberOfRealisations, int aNumberOfSteps, double aStepSize, Integer rebalancingInterval) {
        int tmpProcDim = this.myProcess.size();
        ArrayR064 tmpInitialValues = this.myProcess.getValues();
        Comparable[] tmpValues = new Comparable[tmpProcDim];
        for (int p = 0; p < tmpProcDim; ++p) {
            tmpValues[p] = tmpInitialValues.get((long)p);
        }
        List<BigDecimal> tmpWeights = new SimplePortfolio(tmpValues).normalise().getWeights();
        Array2D tmpRealisationValues = (Array2D)Array2D.R064.make(aNumberOfRealisations, aNumberOfSteps);
        for (int r = 0; r < aNumberOfRealisations; ++r) {
            for (int s = 0; s < aNumberOfSteps; ++s) {
                if (rebalancingInterval != null && s != 0 && s % rebalancingInterval == 0) {
                    double tmpPortfolioValue = tmpRealisationValues.doubleValue(r, s - 1);
                    for (int p = 0; p < tmpProcDim; ++p) {
                        this.myProcess.setValue(p, tmpPortfolioValue * tmpWeights.get(p).doubleValue());
                    }
                }
                Array1D<Double> tmpRealisation = this.myProcess.step(aStepSize);
                AggregatorFunction<Double> tmpAggregator = Aggregator.SUM.getFunction(PrimitiveAggregator.getSet());
                tmpRealisation.visitAll(tmpAggregator);
                tmpRealisationValues.set((long)r, (long)s, tmpAggregator.doubleValue());
            }
            this.myProcess.setValues(tmpInitialValues);
        }
        AggregatorFunction<Double> tmpAggregator = Aggregator.SUM.getFunction(PrimitiveAggregator.getSet());
        int i = 0;
        while ((long)i < tmpInitialValues.count()) {
            tmpAggregator.invoke(tmpInitialValues.doubleValue((long)i));
            ++i;
        }
        return new RandomProcess.SimulationResults(tmpAggregator.doubleValue(), tmpRealisationValues);
    }
}

