/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task.iterative;

import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.Array1D;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public abstract class IterativeSolverTask
implements SolverTask<Double> {
    static final NumberContext DEFAULT = NumberContext.ofMath(MathContext.DECIMAL128);
    private NumberContext myAccuracyContext = DEFAULT;
    private BasicLogger myDebugPrinter = null;
    private int myIterationsLimit = Integer.MAX_VALUE;

    static List<Equation> toListOfRows(Access2D<?> body, Access2D<?> rhs) {
        int i;
        int numbEquations = (int)body.countRows();
        int numbVariables = (int)body.countColumns();
        ArrayList<Equation> retVal = new ArrayList<Equation>(numbEquations);
        for (i = 0; i < numbEquations; ++i) {
            retVal.add(new Equation(i, (long)numbVariables, rhs.doubleValue(i)));
        }
        if (body instanceof SparseStore) {
            ((SparseStore)body).nonzeros().forEach(view -> ((Equation)retVal.get(Math.toIntExact(view.row()))).set(view.column(), view.doubleValue()));
        } else {
            for (i = 0; i < numbEquations; ++i) {
                Equation row = (Equation)retVal.get(i);
                for (int j = 0; j < numbVariables; ++j) {
                    double tmpVal = body.doubleValue(i, j);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    row.set((long)j, tmpVal);
                }
            }
        }
        return retVal;
    }

    IterativeSolverTask() {
    }

    public final Configurator configurator() {
        return new Configurator(this);
    }

    @Override
    public final PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        if (templateRHS.countColumns() != 1L) {
            throw new IllegalArgumentException("The RHS must have precisely 1 column!");
        }
        return (PhysicalStore)Primitive64Store.FACTORY.make(templateBody.countColumns(), 1L);
    }

    @Override
    public final Optional<MatrixStore<Double>> solve(MatrixStore<Double> body, MatrixStore<Double> rhs) {
        try {
            return Optional.of(this.solve(body, rhs, this.preallocate(body, rhs)));
        }
        catch (RecoverableCondition xcptn) {
            return Optional.empty();
        }
    }

    protected final void debug(int iteration, double error, Access1D<?> current) {
        if (this.myDebugPrinter != null) {
            this.myDebugPrinter.println("{}: {} \u2013 {}", iteration, error, Array1D.R064.copy((Access1D)current));
        }
    }

    protected final NumberContext getAccuracyContext() {
        return this.myAccuracyContext;
    }

    protected final int getIterationsLimit() {
        return this.myIterationsLimit;
    }

    protected final boolean isDebugPrinterSet() {
        return this.myDebugPrinter != null;
    }

    protected void setAccuracyContext(NumberContext accuracyContext) {
        this.myAccuracyContext = accuracyContext;
    }

    protected void setDebugPrinter(BasicLogger debugPrinter) {
        this.myDebugPrinter = debugPrinter;
    }

    protected void setIterationsLimit(int iterationsLimit) {
        this.myIterationsLimit = iterationsLimit;
    }

    public static interface SparseDelegate {
        public double resolve(List<Equation> var1, PhysicalStore<Double> var2);

        default public double resolve(List<Equation> equations, PhysicalStore<Double> solution, Access1D<?> rhs) {
            int nbEquations = equations.size();
            if (rhs.size() != nbEquations) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < nbEquations; ++i) {
                equations.get(i).setRHS(rhs.doubleValue(i));
            }
            return this.resolve(equations, solution);
        }
    }

    public static final class Configurator {
        private final IterativeSolverTask mySolver;

        private Configurator() {
            this(null);
        }

        Configurator(IterativeSolverTask solver) {
            this.mySolver = solver;
        }

        public Configurator accuracy(NumberContext accuray) {
            if (accuray != null) {
                this.mySolver.setAccuracyContext(accuray);
            } else {
                this.mySolver.setAccuracyContext(DEFAULT);
            }
            return this;
        }

        public Configurator debug(BasicLogger printer) {
            this.mySolver.setDebugPrinter(printer);
            return this;
        }

        public Configurator iterations(int iterations) {
            this.mySolver.setIterationsLimit(iterations);
            return this;
        }
    }
}

