/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.DenseArray;
import org.ojalgo.netio.DataReader;
import org.ojalgo.netio.DataWriter;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.type.function.OperatorWithException;
import org.ojalgo.type.keyvalue.EntryPair;
import org.ojalgo.type.keyvalue.KeyValue;

public interface DataInterpreter<T>
extends DataReader.Deserializer<T>,
DataWriter.Serializer<T> {
    public static final DataInterpreter<String> STRING = new DataInterpreter<String>(){

        @Override
        public String deserialize(DataInput input) throws IOException {
            return input.readUTF();
        }

        @Override
        public void serialize(String data, DataOutput output) throws IOException {
            output.writeUTF(data);
        }
    };

    public static <N extends Comparable<N>> DataInterpreter<ArrayAnyD<N>> newIDX(DenseArray.Factory<N> denseArray) {
        final ArrayAnyD.Factory<N> factory = ArrayAnyD.factory(denseArray);
        return new DataInterpreter<ArrayAnyD<N>>(){

            @Override
            public ArrayAnyD<N> deserialize(DataInput input) throws IOException {
                input.readByte();
                input.readByte();
                byte type = input.readByte();
                int rank = input.readByte();
                long[] structure = new long[rank];
                for (int i = 0; i < rank; ++i) {
                    structure[rank - 1 - i] = input.readInt();
                }
                StructureAnyD data = factory.make(structure);
                long limit = ((ArrayAnyD)data).count();
                block9: for (long i = 0L; i < limit; ++i) {
                    switch (type) {
                        case 8: {
                            ((ArrayAnyD)data).set(i, input.readUnsignedByte());
                            continue block9;
                        }
                        case 9: {
                            ((ArrayAnyD)data).set(i, input.readByte());
                            continue block9;
                        }
                        case 11: {
                            ((ArrayAnyD)data).set(i, input.readShort());
                            continue block9;
                        }
                        case 12: {
                            ((ArrayAnyD)data).set(i, input.readInt());
                            continue block9;
                        }
                        case 13: {
                            ((ArrayAnyD)data).set(i, input.readFloat());
                            continue block9;
                        }
                        case 14: {
                            ((ArrayAnyD)data).set(i, input.readDouble());
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown element type!");
                        }
                    }
                }
                return data;
            }

            @Override
            public void serialize(ArrayAnyD<N> data, DataOutput output) throws IOException {
                int rank = data.rank();
                output.writeByte(0);
                output.writeByte(0);
                output.writeByte(13);
                output.writeByte(rank);
                for (int i = 0; i < rank; ++i) {
                    output.writeInt(data.size(i));
                }
                long limit = data.count();
                for (long i = 0L; i < limit; ++i) {
                    output.writeFloat(data.floatValue(i));
                }
            }
        };
    }

    public static <T> DataInterpreter<EntryPair.KeyedPrimitive<KeyValue.Dual<T>>> newScoredDual(final DataInterpreter<T> keyInterpreter) {
        return new DataInterpreter<EntryPair.KeyedPrimitive<KeyValue.Dual<T>>>(){

            @Override
            public EntryPair.KeyedPrimitive<KeyValue.Dual<T>> deserialize(DataInput input) throws IOException {
                return EntryPair.of(keyInterpreter.deserialize(input), keyInterpreter.deserialize(input), input.readFloat());
            }

            @Override
            public void serialize(EntryPair.KeyedPrimitive<KeyValue.Dual<T>> data, DataOutput output) throws IOException {
                KeyValue.Dual key = (KeyValue.Dual)data.getKey();
                keyInterpreter.serialize(key.first, output);
                keyInterpreter.serialize(key.second, output);
                output.writeFloat(data.floatValue());
            }
        };
    }

    default public DataReader<T> newReader(File file) {
        return DataReader.of(file, this);
    }

    default public DataReader<T> newReader(File file, OperatorWithException<InputStream> filter) {
        return DataReader.of(file, this, filter);
    }

    default public DataWriter<T> newWriter(File file) {
        return DataWriter.of(file, this);
    }

    default public DataWriter<T> newWriter(File file, OperatorWithException<OutputStream> filter) {
        return DataWriter.of(file, this, filter);
    }
}

